
package io.serverlessworkflow.api.branches;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.timeouts.TimeoutsDefinition;


/**
 * Branch Definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "actions",
    "timeouts"
})
public class Branch implements Serializable
{

    /**
     * Branch name
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Branch name")
    private String name;
    /**
     * Actions to be executed in this branch
     * 
     */
    @JsonProperty("actions")
    @JsonPropertyDescription("Actions to be executed in this branch")
    @Valid
    private List<Action> actions = new ArrayList<Action>();
    /**
     * Timeouts Definition
     * 
     */
    @JsonProperty("timeouts")
    @JsonPropertyDescription("Timeouts Definition")
    @Valid
    private TimeoutsDefinition timeouts;
    private final static long serialVersionUID = 8229957601558444839L;

    /**
     * Branch name
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Branch name
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Branch withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Actions to be executed in this branch
     * 
     */
    @JsonProperty("actions")
    public List<Action> getActions() {
        return actions;
    }

    /**
     * Actions to be executed in this branch
     * 
     */
    @JsonProperty("actions")
    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public Branch withActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Timeouts Definition
     * 
     */
    @JsonProperty("timeouts")
    public TimeoutsDefinition getTimeouts() {
        return timeouts;
    }

    /**
     * Timeouts Definition
     * 
     */
    @JsonProperty("timeouts")
    public void setTimeouts(TimeoutsDefinition timeouts) {
        this.timeouts = timeouts;
    }

    public Branch withTimeouts(TimeoutsDefinition timeouts) {
        this.timeouts = timeouts;
        return this;
    }

}
