
package io.serverlessworkflow.api.auth;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "username",
    "password",
    "metadata"
})
public class BasicAuthDefinition implements Serializable
{

    /**
     * String or a workflow expression. Contains the user name
     * (Required)
     * 
     */
    @JsonProperty("username")
    @JsonPropertyDescription("String or a workflow expression. Contains the user name")
    @Size(min = 1)
    @NotNull
    private java.lang.String username;
    /**
     * String or a workflow expression. Contains the user password
     * (Required)
     * 
     */
    @JsonProperty("password")
    @JsonPropertyDescription("String or a workflow expression. Contains the user password")
    @Size(min = 1)
    @NotNull
    private java.lang.String password;
    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    @JsonPropertyDescription("Metadata")
    @Valid
    private Map<String, String> metadata;
    private final static long serialVersionUID = -6123191764856682930L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public BasicAuthDefinition() {
    }

    /**
     * 
     * @param password
     * @param username
     */
    public BasicAuthDefinition(java.lang.String username, java.lang.String password) {
        super();
        this.username = username;
        this.password = password;
    }

    /**
     * String or a workflow expression. Contains the user name
     * (Required)
     * 
     */
    @JsonProperty("username")
    public java.lang.String getUsername() {
        return username;
    }

    /**
     * String or a workflow expression. Contains the user name
     * (Required)
     * 
     */
    @JsonProperty("username")
    public void setUsername(java.lang.String username) {
        this.username = username;
    }

    public BasicAuthDefinition withUsername(java.lang.String username) {
        this.username = username;
        return this;
    }

    /**
     * String or a workflow expression. Contains the user password
     * (Required)
     * 
     */
    @JsonProperty("password")
    public java.lang.String getPassword() {
        return password;
    }

    /**
     * String or a workflow expression. Contains the user password
     * (Required)
     * 
     */
    @JsonProperty("password")
    public void setPassword(java.lang.String password) {
        this.password = password;
    }

    public BasicAuthDefinition withPassword(java.lang.String password) {
        this.password = password;
        return this;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public Map<String, String> getMetadata() {
        return metadata;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public BasicAuthDefinition withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

}
