
package io.serverlessworkflow.api.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.events.EventRef;
import io.serverlessworkflow.api.filters.ActionDataFilter;
import io.serverlessworkflow.api.functions.FunctionRef;
import io.serverlessworkflow.api.functions.SubFlowRef;
import io.serverlessworkflow.api.sleep.Sleep;


/**
 * Action Definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "id",
    "name",
    "functionRef",
    "eventRef",
    "subFlowRef",
    "sleep",
    "retryRef",
    "nonRetryableErrors",
    "retryableErrors",
    "actionDataFilter",
    "condition"
})
public class Action implements Serializable
{

    /**
     * Unique action identifier
     * 
     */
    @JsonProperty("id")
    @JsonPropertyDescription("Unique action identifier")
    private String id;
    /**
     * Unique action definition name
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Unique action definition name")
    private String name;
    @JsonProperty("functionRef")
    @Valid
    private FunctionRef functionRef;
    /**
     * Event References
     * 
     */
    @JsonProperty("eventRef")
    @JsonPropertyDescription("Event References")
    @Valid
    private EventRef eventRef;
    @JsonProperty("subFlowRef")
    @Valid
    private SubFlowRef subFlowRef;
    @JsonProperty("sleep")
    @Valid
    private Sleep sleep;
    /**
     * References a defined workflow retry definition. If not defined the default retry policy is assumed
     * 
     */
    @JsonProperty("retryRef")
    @JsonPropertyDescription("References a defined workflow retry definition. If not defined the default retry policy is assumed")
    private String retryRef;
    /**
     * List of unique references to defined workflow errors for which the action should not be retried. Used only when `autoRetries` is set to `true`
     * 
     */
    @JsonProperty("nonRetryableErrors")
    @JsonPropertyDescription("List of unique references to defined workflow errors for which the action should not be retried. Used only when `autoRetries` is set to `true`")
    @Size(min = 1)
    @Valid
    private List<String> nonRetryableErrors = new ArrayList<String>();
    /**
     * List of unique references to defined workflow errors for which the action should be retried. Used only when `autoRetries` is set to `false`
     * 
     */
    @JsonProperty("retryableErrors")
    @JsonPropertyDescription("List of unique references to defined workflow errors for which the action should be retried. Used only when `autoRetries` is set to `false`")
    @Size(min = 1)
    @Valid
    private List<String> retryableErrors = new ArrayList<String>();
    @JsonProperty("actionDataFilter")
    @Valid
    private ActionDataFilter actionDataFilter;
    /**
     * Expression, if defined, must evaluate to true for this action to be performed. If false, action is disregarded
     * 
     */
    @JsonProperty("condition")
    @JsonPropertyDescription("Expression, if defined, must evaluate to true for this action to be performed. If false, action is disregarded")
    @Size(min = 1)
    private String condition;
    private final static long serialVersionUID = 5349382716473763088L;

    /**
     * Unique action identifier
     * 
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * Unique action identifier
     * 
     */
    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public Action withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Unique action definition name
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Unique action definition name
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Action withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("functionRef")
    public FunctionRef getFunctionRef() {
        return functionRef;
    }

    @JsonProperty("functionRef")
    public void setFunctionRef(FunctionRef functionRef) {
        this.functionRef = functionRef;
    }

    public Action withFunctionRef(FunctionRef functionRef) {
        this.functionRef = functionRef;
        return this;
    }

    /**
     * Event References
     * 
     */
    @JsonProperty("eventRef")
    public EventRef getEventRef() {
        return eventRef;
    }

    /**
     * Event References
     * 
     */
    @JsonProperty("eventRef")
    public void setEventRef(EventRef eventRef) {
        this.eventRef = eventRef;
    }

    public Action withEventRef(EventRef eventRef) {
        this.eventRef = eventRef;
        return this;
    }

    @JsonProperty("subFlowRef")
    public SubFlowRef getSubFlowRef() {
        return subFlowRef;
    }

    @JsonProperty("subFlowRef")
    public void setSubFlowRef(SubFlowRef subFlowRef) {
        this.subFlowRef = subFlowRef;
    }

    public Action withSubFlowRef(SubFlowRef subFlowRef) {
        this.subFlowRef = subFlowRef;
        return this;
    }

    @JsonProperty("sleep")
    public Sleep getSleep() {
        return sleep;
    }

    @JsonProperty("sleep")
    public void setSleep(Sleep sleep) {
        this.sleep = sleep;
    }

    public Action withSleep(Sleep sleep) {
        this.sleep = sleep;
        return this;
    }

    /**
     * References a defined workflow retry definition. If not defined the default retry policy is assumed
     * 
     */
    @JsonProperty("retryRef")
    public String getRetryRef() {
        return retryRef;
    }

    /**
     * References a defined workflow retry definition. If not defined the default retry policy is assumed
     * 
     */
    @JsonProperty("retryRef")
    public void setRetryRef(String retryRef) {
        this.retryRef = retryRef;
    }

    public Action withRetryRef(String retryRef) {
        this.retryRef = retryRef;
        return this;
    }

    /**
     * List of unique references to defined workflow errors for which the action should not be retried. Used only when `autoRetries` is set to `true`
     * 
     */
    @JsonProperty("nonRetryableErrors")
    public List<String> getNonRetryableErrors() {
        return nonRetryableErrors;
    }

    /**
     * List of unique references to defined workflow errors for which the action should not be retried. Used only when `autoRetries` is set to `true`
     * 
     */
    @JsonProperty("nonRetryableErrors")
    public void setNonRetryableErrors(List<String> nonRetryableErrors) {
        this.nonRetryableErrors = nonRetryableErrors;
    }

    public Action withNonRetryableErrors(List<String> nonRetryableErrors) {
        this.nonRetryableErrors = nonRetryableErrors;
        return this;
    }

    /**
     * List of unique references to defined workflow errors for which the action should be retried. Used only when `autoRetries` is set to `false`
     * 
     */
    @JsonProperty("retryableErrors")
    public List<String> getRetryableErrors() {
        return retryableErrors;
    }

    /**
     * List of unique references to defined workflow errors for which the action should be retried. Used only when `autoRetries` is set to `false`
     * 
     */
    @JsonProperty("retryableErrors")
    public void setRetryableErrors(List<String> retryableErrors) {
        this.retryableErrors = retryableErrors;
    }

    public Action withRetryableErrors(List<String> retryableErrors) {
        this.retryableErrors = retryableErrors;
        return this;
    }

    @JsonProperty("actionDataFilter")
    public ActionDataFilter getActionDataFilter() {
        return actionDataFilter;
    }

    @JsonProperty("actionDataFilter")
    public void setActionDataFilter(ActionDataFilter actionDataFilter) {
        this.actionDataFilter = actionDataFilter;
    }

    public Action withActionDataFilter(ActionDataFilter actionDataFilter) {
        this.actionDataFilter = actionDataFilter;
        return this;
    }

    /**
     * Expression, if defined, must evaluate to true for this action to be performed. If false, action is disregarded
     * 
     */
    @JsonProperty("condition")
    public String getCondition() {
        return condition;
    }

    /**
     * Expression, if defined, must evaluate to true for this action to be performed. If false, action is disregarded
     * 
     */
    @JsonProperty("condition")
    public void setCondition(String condition) {
        this.condition = condition;
    }

    public Action withCondition(String condition) {
        this.condition = condition;
        return this;
    }

}
