/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.webflux;

import io.sentry.IHub;
import io.sentry.ITransaction;
import io.sentry.Sentry;
import io.sentry.spring.jakarta.webflux.AbstractSentryWebFilter;
import io.sentry.spring.jakarta.webflux.ReactorUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@ApiStatus.Experimental
public final class SentryWebFilterWithThreadLocalAccessor
extends AbstractSentryWebFilter {
    public static final String TRACE_ORIGIN = "auto.spring_jakarta.webflux";

    public SentryWebFilterWithThreadLocalAccessor(@NotNull IHub hub) {
        super(hub);
    }

    public Mono<Void> filter(@NotNull ServerWebExchange serverWebExchange, @NotNull WebFilterChain webFilterChain) {
        @NotNull TransactionContainer transactionContainer = new TransactionContainer();
        return ReactorUtils.withSentryNewMainHubClone(webFilterChain.filter(serverWebExchange).doFinally(__ -> this.doFinally(serverWebExchange, Sentry.getCurrentHub(), transactionContainer.transaction)).doOnError(e -> this.doOnError(transactionContainer.transaction, (Throwable)e)).doFirst(() -> {
            ITransaction transaction;
            this.doFirst(serverWebExchange, Sentry.getCurrentHub());
            transactionContainer.transaction = transaction = this.maybeStartTransaction(Sentry.getCurrentHub(), serverWebExchange.getRequest());
            if (transaction != null) {
                transaction.getSpanContext().setOrigin(TRACE_ORIGIN);
            }
        }));
    }

    private static class TransactionContainer {
        @Nullable
        private volatile ITransaction transaction;

        private TransactionContainer() {
        }
    }
}

