/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.boot.jakarta;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationListener;

final class SentrySpringVersionChecker
implements ApplicationListener<ApplicationContextInitializedEvent> {
    private static final Log logger = LogFactory.getLog(SentrySpringVersionChecker.class);

    SentrySpringVersionChecker() {
    }

    public void onApplicationEvent(ApplicationContextInitializedEvent event) {
        if (!SpringBootVersion.getVersion().startsWith("3")) {
            logger.warn((Object)"############################### WARNING ###############################");
            logger.warn((Object)"##                                                                   ##");
            logger.warn((Object)"##            !Incompatible Spring Boot Version detected!            ##");
            logger.warn((Object)"##              Please see the sentry docs linked below              ##");
            logger.warn((Object)"##                Choose your Spring Boot version and                ##");
            logger.warn((Object)"##                  install the matching dependency                  ##");
            logger.warn((Object)"##                                                                   ##");
            logger.warn((Object)"## https://docs.sentry.io/platforms/java/guides/spring-boot/#install ##");
            logger.warn((Object)"##                                                                   ##");
            logger.warn((Object)"#######################################################################");
        }
    }
}

