/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure.provider;

import io.seata.config.Configuration;
import io.seata.config.ExtConfigurationProvider;
import io.seata.spring.boot.autoconfigure.StarterConstants;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class SpringBootConfigurationProvider
implements ExtConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootConfigurationProvider.class);
    private static final String INTERCEPT_METHOD_PREFIX = "get";

    public Configuration provide(final Configuration originalConfiguration) {
        return (Configuration)Enhancer.create(originalConfiguration.getClass(), (Callback)new MethodInterceptor(){

            public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
                if (method.getName().startsWith(SpringBootConfigurationProvider.INTERCEPT_METHOD_PREFIX) && args.length > 0) {
                    Object result = null;
                    String rawDataId = (String)args[0];
                    if (args.length == 1) {
                        result = SpringBootConfigurationProvider.this.get(SpringBootConfigurationProvider.this.convertDataId(rawDataId));
                    } else if (args.length == 2) {
                        result = SpringBootConfigurationProvider.this.get(SpringBootConfigurationProvider.this.convertDataId(rawDataId), args[1]);
                    } else if (args.length == 3) {
                        result = SpringBootConfigurationProvider.this.get(SpringBootConfigurationProvider.this.convertDataId(rawDataId), args[1], (Long)args[2]);
                    }
                    if (result != null) {
                        if (method.getReturnType().equals(String.class)) {
                            return String.valueOf(result);
                        }
                        return result;
                    }
                }
                return method.invoke((Object)originalConfiguration, args);
            }
        });
    }

    private Object get(String dataId, Object defaultValue, long timeoutMills) throws IllegalAccessException {
        return this.get(dataId, defaultValue);
    }

    private Object get(String dataId, Object defaultValue) throws IllegalAccessException {
        Object result = this.get(dataId);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    private Object get(String dataId) throws IllegalAccessException {
        String propertyPrefix = this.getPropertyPrefix(dataId);
        Object propertyObject = StarterConstants.PROPERTY_BEAN_MAP.get(propertyPrefix);
        if (propertyObject != null) {
            String propertySuffix = this.getPropertySuffix(dataId);
            Optional<Field> fieldOptional = Stream.of(propertyObject.getClass().getDeclaredFields()).filter(f -> f.getName().equalsIgnoreCase(propertySuffix)).findAny();
            if (fieldOptional.isPresent()) {
                Field field = fieldOptional.get();
                field.setAccessible(true);
                Object valueObject = field.get(propertyObject);
                if (valueObject instanceof Map) {
                    String key = StringUtils.substringAfterLast((String)dataId, (String)String.valueOf('.'));
                    valueObject = ((Map)valueObject).get(key);
                }
                return valueObject;
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Property bean with prefix '{}' was not found in `StarterConstants.PROPERTY_BEAN_MAP`. Please inform the {} committer to fix this BUG.", (Object)propertyPrefix, (Object)"seata");
        }
        return null;
    }

    private String convertDataId(String rawDataId) {
        if (rawDataId.endsWith("grouplist")) {
            String suffix = StringUtils.removeEnd((String)rawDataId, (String)".grouplist");
            return "seata.service.grouplist." + suffix;
        }
        return "seata." + rawDataId;
    }

    private String getPropertyPrefix(String dataId) {
        if (dataId.contains("vgroupMapping")) {
            return "seata.service";
        }
        if (dataId.contains("grouplist")) {
            return "seata.service";
        }
        return StringUtils.substringBeforeLast((String)dataId, (String)String.valueOf('.'));
    }

    private String getPropertySuffix(String dataId) {
        if (dataId.contains("vgroupMapping")) {
            return "vgroupMapping";
        }
        if (dataId.contains("grouplist")) {
            return "grouplist";
        }
        return StringUtils.substringAfterLast((String)dataId, (String)String.valueOf('.'));
    }
}

