/*
 * Decompiled with CFR 0.152.
 */
package io.seata.codec.protobuf;

import io.seata.codec.protobuf.ProtobufHelper;
import io.seata.common.exception.ShouldNeverHappenException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ProtobufSerializer {
    private static final ProtobufHelper PROTOBUF_HELPER = new ProtobufHelper();
    private static final String METHOD_TOBYTEARRAY = "toByteArray";
    private static final String METHOD_PARSEFROM = "parseFrom";

    public static byte[] serializeContent(Object request) {
        Class<?> clazz = request.getClass();
        Method method = (Method)ProtobufSerializer.PROTOBUF_HELPER.toByteArrayMethodMap.get(clazz);
        if (method == null) {
            try {
                method = clazz.getMethod(METHOD_TOBYTEARRAY, new Class[0]);
                method.setAccessible(true);
                ProtobufSerializer.PROTOBUF_HELPER.toByteArrayMethodMap.put(clazz, method);
            }
            catch (Exception e) {
                throw new ShouldNeverHappenException("Cannot found method " + clazz.getName() + ".toByteArray(), please check the generated code.", (Throwable)e);
            }
        }
        byte[] bytes = new byte[]{};
        try {
            bytes = (byte[])method.invoke(request, new Object[0]);
        }
        catch (Exception e) {
            throw new ShouldNeverHappenException("serialize occurs exception", (Throwable)e);
        }
        return bytes;
    }

    public static <T> T deserializeContent(String responseClazz, byte[] content) {
        Object result;
        if (content == null || content.length == 0) {
            return null;
        }
        Class clazz = PROTOBUF_HELPER.getPbClass(responseClazz);
        Method method = (Method)ProtobufSerializer.PROTOBUF_HELPER.parseFromMethodMap.get(clazz);
        if (method == null) {
            try {
                method = clazz.getMethod(METHOD_PARSEFROM, byte[].class);
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new ShouldNeverHappenException("Cannot found static method " + clazz.getName() + ".parseFrom(byte[]), please check the generated code");
                }
                method.setAccessible(true);
                ProtobufSerializer.PROTOBUF_HELPER.parseFromMethodMap.put(clazz, method);
            }
            catch (NoSuchMethodException e) {
                throw new ShouldNeverHappenException("Cannot found method " + clazz.getName() + ".parseFrom(byte[]), please check the generated code", (Throwable)e);
            }
        }
        try {
            result = method.invoke(null, new Object[]{content});
        }
        catch (Exception e) {
            throw new ShouldNeverHappenException("Error when invoke " + clazz.getName() + ".parseFrom(byte[]).", (Throwable)e);
        }
        return (T)result;
    }
}

