/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext;

import io.seata.common.exception.FrameworkException;
import io.seata.common.util.CollectionUtils;
import io.seata.saga.engine.pcext.InterceptableStateHandler;
import io.seata.saga.engine.pcext.StateHandler;
import io.seata.saga.engine.pcext.StateHandlerInterceptor;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.pcext.handlers.ChoiceStateHandler;
import io.seata.saga.engine.pcext.handlers.CompensationTriggerStateHandler;
import io.seata.saga.engine.pcext.handlers.FailEndStateHandler;
import io.seata.saga.engine.pcext.handlers.LoopStartStateHandler;
import io.seata.saga.engine.pcext.handlers.ScriptTaskStateHandler;
import io.seata.saga.engine.pcext.handlers.ServiceTaskStateHandler;
import io.seata.saga.engine.pcext.handlers.SubStateMachineHandler;
import io.seata.saga.engine.pcext.handlers.SucceedEndStateHandler;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.proctrl.handler.ProcessHandler;
import io.seata.saga.statelang.domain.State;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StateMachineProcessHandler
implements ProcessHandler {
    private final Map<String, StateHandler> stateHandlers = new ConcurrentHashMap<String, StateHandler>();

    @Override
    public void process(ProcessContext context) throws FrameworkException {
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        State state = instruction.getState(context);
        String stateType = state.getType();
        StateHandler stateHandler = this.stateHandlers.get(stateType);
        List<StateHandlerInterceptor> interceptors = null;
        if (stateHandler instanceof InterceptableStateHandler) {
            interceptors = ((InterceptableStateHandler)stateHandler).getInterceptors();
        }
        ArrayList<StateHandlerInterceptor> executedInterceptors = null;
        Exception exception = null;
        try {
            if (CollectionUtils.isNotEmpty(interceptors)) {
                executedInterceptors = new ArrayList<StateHandlerInterceptor>(interceptors.size());
                for (StateHandlerInterceptor interceptor : interceptors) {
                    executedInterceptors.add(interceptor);
                    interceptor.preProcess(context);
                }
            }
            stateHandler.process(context);
        }
        catch (Exception e) {
            exception = e;
            throw e;
        }
        finally {
            if (CollectionUtils.isNotEmpty(executedInterceptors)) {
                for (int i = executedInterceptors.size() - 1; i >= 0; --i) {
                    StateHandlerInterceptor interceptor = (StateHandlerInterceptor)executedInterceptors.get(i);
                    interceptor.postProcess(context, exception);
                }
            }
        }
    }

    public void initDefaultHandlers() {
        if (this.stateHandlers.isEmpty()) {
            this.stateHandlers.put("ServiceTask", new ServiceTaskStateHandler());
            this.stateHandlers.put("ScriptTask", new ScriptTaskStateHandler());
            this.stateHandlers.put("CompensateSubMachine", new ServiceTaskStateHandler());
            this.stateHandlers.put("SubStateMachine", new SubStateMachineHandler());
            this.stateHandlers.put("Choice", new ChoiceStateHandler());
            this.stateHandlers.put("Succeed", new SucceedEndStateHandler());
            this.stateHandlers.put("Fail", new FailEndStateHandler());
            this.stateHandlers.put("CompensationTrigger", new CompensationTriggerStateHandler());
            this.stateHandlers.put("LoopStart", new LoopStartStateHandler());
        }
    }

    public Map<String, StateHandler> getStateHandlers() {
        return this.stateHandlers;
    }

    public void setStateHandlers(Map<String, StateHandler> stateHandlers) {
        this.stateHandlers.putAll(stateHandlers);
    }
}

