/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.BucketAggregation;
import io.searchbox.core.search.aggregation.Range;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class GeoDistanceAggregation
extends BucketAggregation {
    public static final String TYPE = "geo_distance";
    private List<Range> geoDistances = new LinkedList<Range>();

    public GeoDistanceAggregation(String name, JsonObject geoDistanceAggregation) {
        super(name, geoDistanceAggregation);
        if (geoDistanceAggregation.has(String.valueOf((Object)AggregationField.BUCKETS)) && geoDistanceAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).isJsonArray()) {
            this.parseBuckets(geoDistanceAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).getAsJsonArray());
        }
    }

    private void parseBuckets(JsonArray buckets) {
        for (JsonElement bucketv : buckets) {
            JsonObject bucket;
            Range geoDistance = new Range(bucket, (bucket = bucketv.getAsJsonObject()).has(String.valueOf((Object)AggregationField.FROM)) ? Double.valueOf(bucket.get(String.valueOf((Object)AggregationField.FROM)).getAsDouble()) : null, bucket.has(String.valueOf((Object)AggregationField.TO)) ? Double.valueOf(bucket.get(String.valueOf((Object)AggregationField.TO)).getAsDouble()) : null, bucket.has(String.valueOf((Object)AggregationField.DOC_COUNT)) ? Long.valueOf(bucket.get(String.valueOf((Object)AggregationField.DOC_COUNT)).getAsLong()) : null);
            this.geoDistances.add(geoDistance);
        }
    }

    public List<Range> getBuckets() {
        return this.geoDistances;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GeoDistanceAggregation rhs = (GeoDistanceAggregation)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.geoDistances, rhs.geoDistances).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.geoDistances).toHashCode();
    }
}

