/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TooLargePackException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.internal.submodule.SubmoduleValidator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.GitmoduleEntry;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSubclassMap;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.PushCertificate;
import org.eclipse.jgit.transport.PushCertificateParser;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivedPackStatistics;
import org.eclipse.jgit.transport.RefAdvertiser;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.transport.RequestNotYetReadException;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.SideBandOutputStream;
import org.eclipse.jgit.transport.SideBandProgressMonitor;
import org.eclipse.jgit.transport.SignedPushConfig;
import org.eclipse.jgit.transport.TransferConfig;
import org.eclipse.jgit.transport.UserAgent;
import org.eclipse.jgit.util.io.InterruptTimer;
import org.eclipse.jgit.util.io.LimitedInputStream;
import org.eclipse.jgit.util.io.TimeoutInputStream;
import org.eclipse.jgit.util.io.TimeoutOutputStream;

public abstract class BaseReceivePack {
    private final Repository db;
    private final RevWalk walk;
    private boolean biDirectionalPipe = true;
    private boolean expectDataAfterPackFooter;
    private ObjectChecker objectChecker;
    private boolean allowCreates;
    private boolean allowAnyDeletes;
    private boolean allowBranchDeletes;
    private boolean allowNonFastForwards;
    private boolean allowPushOptions;
    private boolean atomic;
    private boolean allowOfsDelta;
    private boolean allowQuiet = true;
    private PersonIdent refLogIdent;
    private AdvertiseRefsHook advertiseRefsHook;
    private RefFilter refFilter;
    private int timeout;
    private InterruptTimer timer;
    private TimeoutInputStream timeoutIn;
    private OutputStream origOut;
    protected InputStream rawIn;
    protected OutputStream rawOut;
    protected OutputStream msgOut;
    private SideBandOutputStream errOut;
    protected PacketLineIn pckIn;
    protected PacketLineOut pckOut;
    private final MessageOutputWrapper msgOutWrapper = new MessageOutputWrapper();
    private PackParser parser;
    private Map<String, Ref> refs;
    private Set<ObjectId> advertisedHaves;
    private Set<String> enabledCapabilities;
    String userAgent;
    private Set<ObjectId> clientShallowCommits;
    private List<ReceiveCommand> commands;
    private long maxCommandBytes;
    private long maxDiscardBytes;
    private StringBuilder advertiseError;
    private boolean sideBand;
    private boolean quiet;
    private PackLock packLock;
    private boolean checkReferencedIsReachable;
    private long maxObjectSizeLimit;
    private long maxPackSizeLimit = -1L;
    private Long packSize;
    private PushCertificateParser pushCertificateParser;
    private SignedPushConfig signedPushConfig;
    private PushCertificate pushCert;
    private ReceivedPackStatistics stats;

    public PushCertificate getPushCertificate() {
        return this.pushCert;
    }

    public void setPushCertificate(PushCertificate cert) {
        this.pushCert = cert;
    }

    protected BaseReceivePack(Repository into) {
        this.db = into;
        this.walk = new RevWalk(this.db);
        TransferConfig tc = this.db.getConfig().get(TransferConfig.KEY);
        this.objectChecker = tc.newReceiveObjectChecker();
        ReceiveConfig rc = this.db.getConfig().get(ReceiveConfig::new);
        this.allowCreates = rc.allowCreates;
        this.allowAnyDeletes = true;
        this.allowBranchDeletes = rc.allowDeletes;
        this.allowNonFastForwards = rc.allowNonFastForwards;
        this.allowOfsDelta = rc.allowOfsDelta;
        this.allowPushOptions = rc.allowPushOptions;
        this.maxCommandBytes = rc.maxCommandBytes;
        this.maxDiscardBytes = rc.maxDiscardBytes;
        this.advertiseRefsHook = AdvertiseRefsHook.DEFAULT;
        this.refFilter = RefFilter.DEFAULT;
        this.advertisedHaves = new HashSet<ObjectId>();
        this.clientShallowCommits = new HashSet<ObjectId>();
        this.signedPushConfig = rc.signedPush;
    }

    protected abstract String getLockMessageProcessName();

    public final Repository getRepository() {
        return this.db;
    }

    public final RevWalk getRevWalk() {
        return this.walk;
    }

    public final Map<String, Ref> getAdvertisedRefs() {
        return this.refs;
    }

    public void setAdvertisedRefs(Map<String, Ref> allRefs, Set<ObjectId> additionalHaves) {
        this.refs = allRefs != null ? allRefs : this.db.getAllRefs();
        this.refs = this.refFilter.filter(this.refs);
        this.advertisedHaves.clear();
        Ref head = this.refs.get("HEAD");
        if (head != null && head.isSymbolic()) {
            this.refs.remove("HEAD");
        }
        for (Ref ref : this.refs.values()) {
            if (ref.getObjectId() == null) continue;
            this.advertisedHaves.add(ref.getObjectId());
        }
        if (additionalHaves != null) {
            this.advertisedHaves.addAll(additionalHaves);
        } else {
            this.advertisedHaves.addAll(this.db.getAdditionalHaves());
        }
    }

    public final Set<ObjectId> getAdvertisedObjects() {
        return this.advertisedHaves;
    }

    public boolean isCheckReferencedObjectsAreReachable() {
        return this.checkReferencedIsReachable;
    }

    public void setCheckReferencedObjectsAreReachable(boolean b) {
        this.checkReferencedIsReachable = b;
    }

    public boolean isBiDirectionalPipe() {
        return this.biDirectionalPipe;
    }

    public void setBiDirectionalPipe(boolean twoWay) {
        this.biDirectionalPipe = twoWay;
    }

    public boolean isExpectDataAfterPackFooter() {
        return this.expectDataAfterPackFooter;
    }

    public void setExpectDataAfterPackFooter(boolean e) {
        this.expectDataAfterPackFooter = e;
    }

    public boolean isCheckReceivedObjects() {
        return this.objectChecker != null;
    }

    public void setCheckReceivedObjects(boolean check) {
        if (check && this.objectChecker == null) {
            this.setObjectChecker(new ObjectChecker());
        } else if (!check && this.objectChecker != null) {
            this.setObjectChecker(null);
        }
    }

    public void setObjectChecker(ObjectChecker impl) {
        this.objectChecker = impl;
    }

    public boolean isAllowCreates() {
        return this.allowCreates;
    }

    public void setAllowCreates(boolean canCreate) {
        this.allowCreates = canCreate;
    }

    public boolean isAllowDeletes() {
        return this.allowAnyDeletes;
    }

    public void setAllowDeletes(boolean canDelete) {
        this.allowAnyDeletes = canDelete;
    }

    public boolean isAllowBranchDeletes() {
        return this.allowBranchDeletes;
    }

    public void setAllowBranchDeletes(boolean canDelete) {
        this.allowBranchDeletes = canDelete;
    }

    public boolean isAllowNonFastForwards() {
        return this.allowNonFastForwards;
    }

    public void setAllowNonFastForwards(boolean canRewind) {
        this.allowNonFastForwards = canRewind;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public void setAtomic(boolean atomic) {
        this.atomic = atomic;
    }

    public PersonIdent getRefLogIdent() {
        return this.refLogIdent;
    }

    public void setRefLogIdent(PersonIdent pi) {
        this.refLogIdent = pi;
    }

    public AdvertiseRefsHook getAdvertiseRefsHook() {
        return this.advertiseRefsHook;
    }

    public RefFilter getRefFilter() {
        return this.refFilter;
    }

    public void setAdvertiseRefsHook(AdvertiseRefsHook advertiseRefsHook) {
        this.advertiseRefsHook = advertiseRefsHook != null ? advertiseRefsHook : AdvertiseRefsHook.DEFAULT;
    }

    public void setRefFilter(RefFilter refFilter) {
        this.refFilter = refFilter != null ? refFilter : RefFilter.DEFAULT;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public void setMaxCommandBytes(long limit) {
        this.maxCommandBytes = limit;
    }

    public void setMaxCommandDiscardBytes(long limit) {
        this.maxDiscardBytes = limit;
    }

    public void setMaxObjectSizeLimit(long limit) {
        this.maxObjectSizeLimit = limit;
    }

    public void setMaxPackSizeLimit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().receivePackInvalidLimit, limit));
        }
        this.maxPackSizeLimit = limit;
    }

    public boolean isSideBand() throws RequestNotYetReadException {
        this.checkRequestWasRead();
        return this.enabledCapabilities.contains("side-band-64k");
    }

    public boolean isAllowQuiet() {
        return this.allowQuiet;
    }

    public void setAllowQuiet(boolean allow) {
        this.allowQuiet = allow;
    }

    public boolean isAllowPushOptions() {
        return this.allowPushOptions;
    }

    public void setAllowPushOptions(boolean allow) {
        this.allowPushOptions = allow;
    }

    public boolean isQuiet() throws RequestNotYetReadException {
        this.checkRequestWasRead();
        return this.quiet;
    }

    public void setSignedPushConfig(SignedPushConfig cfg) {
        this.signedPushConfig = cfg;
    }

    private PushCertificateParser getPushCertificateParser() {
        if (this.pushCertificateParser == null) {
            this.pushCertificateParser = new PushCertificateParser(this.db, this.signedPushConfig);
        }
        return this.pushCertificateParser;
    }

    public String getPeerUserAgent() {
        return UserAgent.getAgent(this.enabledCapabilities, this.userAgent);
    }

    public List<ReceiveCommand> getAllCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public void sendError(String what) {
        if (this.refs == null) {
            if (this.advertiseError == null) {
                this.advertiseError = new StringBuilder();
            }
            this.advertiseError.append(what).append('\n');
        } else {
            this.msgOutWrapper.write(Constants.encode("error: " + what + "\n"));
        }
    }

    private void fatalError(String msg) {
        if (this.errOut != null) {
            try {
                this.errOut.write(Constants.encode(msg));
                this.errOut.flush();
            }
            catch (IOException iOException) {}
        } else {
            this.sendError(msg);
        }
    }

    public void sendMessage(String what) {
        this.msgOutWrapper.write(Constants.encode(what + "\n"));
    }

    public OutputStream getMessageOutputStream() {
        return this.msgOutWrapper;
    }

    public long getPackSize() {
        if (this.packSize != null) {
            return this.packSize;
        }
        throw new IllegalStateException(JGitText.get().packSizeNotSetYet);
    }

    protected Set<ObjectId> getClientShallowCommits() {
        return this.clientShallowCommits;
    }

    protected boolean hasCommands() {
        return !this.commands.isEmpty();
    }

    protected boolean hasError() {
        return this.advertiseError != null;
    }

    protected void init(InputStream input, OutputStream output, OutputStream messages) {
        this.origOut = output;
        this.rawIn = input;
        this.rawOut = output;
        this.msgOut = messages;
        if (this.timeout > 0) {
            Thread caller = Thread.currentThread();
            this.timer = new InterruptTimer(caller.getName() + "-Timer");
            this.timeoutIn = new TimeoutInputStream(this.rawIn, this.timer);
            TimeoutOutputStream o = new TimeoutOutputStream(this.rawOut, this.timer);
            this.timeoutIn.setTimeout(this.timeout * 1000);
            o.setTimeout(this.timeout * 1000);
            this.rawIn = this.timeoutIn;
            this.rawOut = o;
        }
        this.pckIn = new PacketLineIn(this.rawIn);
        this.pckOut = new PacketLineOut(this.rawOut);
        this.pckOut.setFlushOnEnd(false);
        this.enabledCapabilities = new HashSet<String>();
        this.commands = new ArrayList<ReceiveCommand>();
    }

    protected Map<String, Ref> getAdvertisedOrDefaultRefs() {
        if (this.refs == null) {
            this.setAdvertisedRefs(null, null);
        }
        return this.refs;
    }

    protected void receivePackAndCheckConnectivity() throws IOException {
        this.receivePack();
        if (this.needCheckConnectivity()) {
            this.checkSubmodules();
            this.checkConnectivity();
        }
        this.parser = null;
    }

    protected void unlockPack() throws IOException {
        if (this.packLock != null) {
            this.packLock.unlock();
            this.packLock = null;
        }
    }

    public void sendAdvertisedRefs(RefAdvertiser adv) throws IOException, ServiceMayNotContinueException {
        String nonce;
        if (this.advertiseError != null) {
            adv.writeOne("ERR " + this.advertiseError);
            return;
        }
        try {
            this.advertiseRefsHook.advertiseRefs(this);
        }
        catch (ServiceMayNotContinueException fail) {
            if (fail.getMessage() != null) {
                adv.writeOne("ERR " + fail.getMessage());
                fail.setOutput();
            }
            throw fail;
        }
        adv.init(this.db);
        adv.advertiseCapability("side-band-64k");
        adv.advertiseCapability("delete-refs");
        adv.advertiseCapability("report-status");
        if (this.allowQuiet) {
            adv.advertiseCapability("quiet");
        }
        if ((nonce = this.getPushCertificateParser().getAdvertiseNonce()) != null) {
            adv.advertiseCapability(nonce);
        }
        if (this.db.getRefDatabase().performsAtomicTransactions()) {
            adv.advertiseCapability("atomic");
        }
        if (this.allowOfsDelta) {
            adv.advertiseCapability("ofs-delta");
        }
        if (this.allowPushOptions) {
            adv.advertiseCapability("push-options");
        }
        adv.advertiseCapability("agent", UserAgent.get());
        adv.send(this.getAdvertisedOrDefaultRefs());
        for (ObjectId obj : this.advertisedHaves) {
            adv.advertiseHave(obj);
        }
        if (adv.isEmpty()) {
            adv.advertiseId(ObjectId.zeroId(), "capabilities^{}");
        }
        adv.end();
    }

    @Nullable
    public ReceivedPackStatistics getReceivedPackStatistics() {
        return this.stats;
    }

    protected void recvCommands() throws IOException {
        PacketLineIn pck = this.maxCommandBytes > 0L ? new PacketLineIn(this.rawIn, this.maxCommandBytes) : this.pckIn;
        PushCertificateParser certParser = this.getPushCertificateParser();
        boolean firstPkt = true;
        try {
            while (true) {
                String line;
                try {
                    line = pck.readString();
                }
                catch (EOFException eof) {
                    if (this.commands.isEmpty()) {
                        return;
                    }
                    throw eof;
                }
                if (line == PacketLineIn.END) break;
                if (line.length() >= 48 && line.startsWith("shallow ")) {
                    this.parseShallow(line.substring(8, 48));
                    continue;
                }
                if (firstPkt) {
                    firstPkt = false;
                    FirstLine firstLine = new FirstLine(line);
                    this.enabledCapabilities = firstLine.getCapabilities();
                    line = firstLine.getLine();
                    this.enableCapabilities();
                    if (line.equals("push-cert")) {
                        certParser.receiveHeader(pck, !this.isBiDirectionalPipe());
                        continue;
                    }
                }
                if (line.equals("-----BEGIN PGP SIGNATURE-----")) {
                    certParser.receiveSignature(pck);
                    continue;
                }
                ReceiveCommand cmd = BaseReceivePack.parseCommand(line);
                if (cmd.getRefName().equals("HEAD")) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_CURRENT_BRANCH);
                } else {
                    cmd.setRef(this.refs.get(cmd.getRefName()));
                }
                this.commands.add(cmd);
                if (!certParser.enabled()) continue;
                certParser.addCommand(cmd);
            }
            this.pushCert = certParser.build();
            if (this.hasCommands()) {
                this.readPostCommands(pck);
            }
        }
        catch (PackProtocolException e) {
            this.discardCommands();
            this.fatalError(e.getMessage());
            throw e;
        }
        catch (PacketLineIn.InputOverLimitIOException e) {
            String msg = JGitText.get().tooManyCommands;
            this.discardCommands();
            this.fatalError(msg);
            throw new PackProtocolException(msg);
        }
    }

    private void discardCommands() {
        if (this.sideBand) {
            long max = this.maxDiscardBytes;
            if (max < 0L) {
                max = Math.max(3L * this.maxCommandBytes, 0x300000L);
            }
            try {
                new PacketLineIn(this.rawIn, max).discardUntilEnd();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void parseShallow(String idStr) throws PackProtocolException {
        ObjectId id;
        try {
            id = ObjectId.fromString(idStr);
        }
        catch (InvalidObjectIdException e) {
            throw new PackProtocolException(e.getMessage(), e);
        }
        this.clientShallowCommits.add(id);
    }

    static ReceiveCommand parseCommand(String line) throws PackProtocolException {
        ObjectId newId;
        ObjectId oldId;
        if (line == null || line.length() < 83) {
            throw new PackProtocolException(JGitText.get().errorInvalidProtocolWantedOldNewRef);
        }
        String oldStr = line.substring(0, 40);
        String newStr = line.substring(41, 81);
        try {
            oldId = ObjectId.fromString(oldStr);
            newId = ObjectId.fromString(newStr);
        }
        catch (InvalidObjectIdException e) {
            throw new PackProtocolException(JGitText.get().errorInvalidProtocolWantedOldNewRef, e);
        }
        String name = line.substring(82);
        if (!Repository.isValidRefName(name)) {
            throw new PackProtocolException(JGitText.get().errorInvalidProtocolWantedOldNewRef);
        }
        return new ReceiveCommand(oldId, newId, name);
    }

    void readPostCommands(PacketLineIn in) throws IOException {
    }

    protected void enableCapabilities() {
        this.sideBand = this.isCapabilityEnabled("side-band-64k");
        boolean bl = this.quiet = this.allowQuiet && this.isCapabilityEnabled("quiet");
        if (this.sideBand) {
            OutputStream out = this.rawOut;
            this.rawOut = new SideBandOutputStream(1, 65520, out);
            this.msgOut = new SideBandOutputStream(2, 65520, out);
            this.errOut = new SideBandOutputStream(3, 65520, out);
            this.pckOut = new PacketLineOut(this.rawOut);
            this.pckOut.setFlushOnEnd(false);
        }
    }

    protected boolean isCapabilityEnabled(String name) {
        return this.enabledCapabilities.contains(name);
    }

    void checkRequestWasRead() {
        if (this.enabledCapabilities == null) {
            throw new RequestNotYetReadException();
        }
    }

    protected boolean needPack() {
        for (ReceiveCommand cmd : this.commands) {
            if (cmd.getType() == ReceiveCommand.Type.DELETE) continue;
            return true;
        }
        return false;
    }

    private void receivePack() throws IOException {
        if (this.timeoutIn != null) {
            this.timeoutIn.setTimeout(10 * this.timeout * 1000);
        }
        NullProgressMonitor receiving = NullProgressMonitor.INSTANCE;
        ProgressMonitor resolving = NullProgressMonitor.INSTANCE;
        if (this.sideBand && !this.quiet) {
            resolving = new SideBandProgressMonitor(this.msgOut);
        }
        try (ObjectInserter ins = this.db.newObjectInserter();){
            String lockMsg = "jgit receive-pack";
            if (this.getRefLogIdent() != null) {
                lockMsg = lockMsg + " from " + this.getRefLogIdent().toExternalString();
            }
            this.parser = ins.newPackParser(this.packInputStream());
            this.parser.setAllowThin(true);
            this.parser.setNeedNewObjectIds(this.checkReferencedIsReachable);
            this.parser.setNeedBaseObjectIds(this.checkReferencedIsReachable);
            this.parser.setCheckEofAfterPackFooter(!this.biDirectionalPipe && !this.isExpectDataAfterPackFooter());
            this.parser.setExpectDataAfterPackFooter(this.isExpectDataAfterPackFooter());
            this.parser.setObjectChecker(this.objectChecker);
            this.parser.setLockMessage(lockMsg);
            this.parser.setMaxObjectSizeLimit(this.maxObjectSizeLimit);
            this.packLock = this.parser.parse(receiving, resolving);
            this.packSize = this.parser.getPackSize();
            this.stats = this.parser.getReceivedPackStatistics();
            ins.flush();
        }
        if (this.timeoutIn != null) {
            this.timeoutIn.setTimeout(this.timeout * 1000);
        }
    }

    private InputStream packInputStream() {
        InputStream packIn = this.rawIn;
        if (this.maxPackSizeLimit >= 0L) {
            packIn = new LimitedInputStream(packIn, this.maxPackSizeLimit){

                @Override
                protected void limitExceeded() throws TooLargePackException {
                    throw new TooLargePackException(this.limit);
                }
            };
        }
        return packIn;
    }

    private boolean needCheckConnectivity() {
        return this.isCheckReceivedObjects() || this.isCheckReferencedObjectsAreReachable() || !this.getClientShallowCommits().isEmpty();
    }

    private void checkSubmodules() throws IOException {
        ObjectDatabase odb = this.db.getObjectDatabase();
        if (this.objectChecker == null) {
            return;
        }
        for (GitmoduleEntry entry : this.objectChecker.getGitsubmodules()) {
            AnyObjectId blobId = entry.getBlobId();
            ObjectLoader blob = odb.open(blobId, 3);
            SubmoduleValidator.assertValidGitModulesFile(new String(blob.getBytes(), StandardCharsets.UTF_8));
        }
    }

    private void checkConnectivity() throws IOException {
        ObjectIdSubclassMap<ObjectId> baseObjects = null;
        ObjectIdSubclassMap<ObjectId> providedObjects = null;
        ProgressMonitor checking = NullProgressMonitor.INSTANCE;
        if (this.sideBand && !this.quiet) {
            SideBandProgressMonitor m3 = new SideBandProgressMonitor(this.msgOut);
            m3.setDelayStart(750L, TimeUnit.MILLISECONDS);
            checking = m3;
        }
        if (this.checkReferencedIsReachable) {
            baseObjects = this.parser.getBaseObjectIds();
            providedObjects = this.parser.getNewObjectIds();
        }
        this.parser = null;
        try (ObjectWalk ow = new ObjectWalk(this.db);){
            RevObject o;
            RevCommit c;
            if (baseObjects != null) {
                ow.sort(RevSort.TOPO);
                if (!baseObjects.isEmpty()) {
                    ow.sort(RevSort.BOUNDARY, true);
                }
            }
            for (ReceiveCommand cmd : this.commands) {
                if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED || cmd.getType() == ReceiveCommand.Type.DELETE) continue;
                ow.markStart(ow.parseAny(cmd.getNewId()));
            }
            for (ObjectId have : this.advertisedHaves) {
                RevObject o2 = ow.parseAny(have);
                ow.markUninteresting(o2);
                if (baseObjects == null || baseObjects.isEmpty()) continue;
                if ((o2 = ow.peel(o2)) instanceof RevCommit) {
                    o2 = ((RevCommit)o2).getTree();
                }
                if (!(o2 instanceof RevTree)) continue;
                ow.markUninteresting(o2);
            }
            checking.beginTask(JGitText.get().countingObjects, 0);
            while ((c = ow.next()) != null) {
                checking.update(1);
                if (providedObjects == null || c.has(RevFlag.UNINTERESTING) || providedObjects.contains(c)) continue;
                throw new MissingObjectException((ObjectId)c, "commit");
            }
            while ((o = ow.nextObject()) != null) {
                checking.update(1);
                if (o.has(RevFlag.UNINTERESTING)) continue;
                if (providedObjects != null) {
                    if (providedObjects.contains(o)) continue;
                    throw new MissingObjectException((ObjectId)o, o.getType());
                }
                if (!(o instanceof RevBlob) || this.db.hasObject(o)) continue;
                throw new MissingObjectException((ObjectId)o, "blob");
            }
            checking.endTask();
            if (baseObjects != null) {
                for (ObjectId id : baseObjects) {
                    o = ow.parseAny(id);
                    if (o.has(RevFlag.UNINTERESTING)) continue;
                    throw new MissingObjectException((ObjectId)o, o.getType());
                }
            }
        }
    }

    protected void validateCommands() {
        for (ReceiveCommand cmd : this.commands) {
            ObjectId id;
            Ref ref = cmd.getRef();
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
            if (cmd.getType() == ReceiveCommand.Type.DELETE) {
                if (!this.isAllowDeletes()) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_NODELETE);
                    continue;
                }
                if (!this.isAllowBranchDeletes() && ref.getName().startsWith("refs/heads/")) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_NODELETE);
                    continue;
                }
            }
            if (cmd.getType() == ReceiveCommand.Type.CREATE) {
                if (!this.isAllowCreates()) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_NOCREATE);
                    continue;
                }
                if (ref != null && !this.isAllowNonFastForwards()) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD);
                    continue;
                }
                if (ref != null) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().refAlreadyExists);
                    continue;
                }
            }
            if (cmd.getType() == ReceiveCommand.Type.DELETE && ref != null) {
                id = ref.getObjectId();
                if (id == null) {
                    id = ObjectId.zeroId();
                }
                if (!ObjectId.zeroId().equals(cmd.getOldId()) && !id.equals(cmd.getOldId())) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().invalidOldIdSent);
                    continue;
                }
            }
            if (cmd.getType() == ReceiveCommand.Type.UPDATE) {
                block26: {
                    RevObject newObj;
                    RevObject oldObj;
                    if (ref == null) {
                        cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().noSuchRef);
                        continue;
                    }
                    id = ref.getObjectId();
                    if (id == null) {
                        cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().cannotUpdateUnbornBranch);
                        continue;
                    }
                    if (!id.equals(cmd.getOldId())) {
                        cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().invalidOldIdSent);
                        continue;
                    }
                    try {
                        oldObj = this.walk.parseAny(cmd.getOldId());
                    }
                    catch (IOException e) {
                        cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT, cmd.getOldId().name());
                        continue;
                    }
                    try {
                        newObj = this.walk.parseAny(cmd.getNewId());
                    }
                    catch (IOException e) {
                        cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT, cmd.getNewId().name());
                        continue;
                    }
                    if (oldObj instanceof RevCommit && newObj instanceof RevCommit) {
                        try {
                            if (this.walk.isMergedInto((RevCommit)oldObj, (RevCommit)newObj)) {
                                cmd.setTypeFastForwardUpdate();
                                break block26;
                            }
                            cmd.setType(ReceiveCommand.Type.UPDATE_NONFASTFORWARD);
                        }
                        catch (MissingObjectException e) {
                            cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT, e.getMessage());
                        }
                        catch (IOException e) {
                            cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON);
                        }
                    } else {
                        cmd.setType(ReceiveCommand.Type.UPDATE_NONFASTFORWARD);
                    }
                }
                if (cmd.getType() == ReceiveCommand.Type.UPDATE_NONFASTFORWARD && !this.isAllowNonFastForwards()) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD);
                    continue;
                }
            }
            if (cmd.getRefName().startsWith("refs/") && Repository.isValidRefName(cmd.getRefName())) continue;
            cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().funnyRefname);
        }
    }

    protected boolean anyRejects() {
        for (ReceiveCommand cmd : this.commands) {
            if (cmd.getResult() == ReceiveCommand.Result.NOT_ATTEMPTED || cmd.getResult() == ReceiveCommand.Result.OK) continue;
            return true;
        }
        return false;
    }

    protected void failPendingCommands() {
        ReceiveCommand.abort(this.commands);
    }

    protected List<ReceiveCommand> filterCommands(ReceiveCommand.Result want) {
        return ReceiveCommand.filter(this.commands, want);
    }

    protected void executeCommands() {
        List<ReceiveCommand> toApply = this.filterCommands(ReceiveCommand.Result.NOT_ATTEMPTED);
        if (toApply.isEmpty()) {
            return;
        }
        ProgressMonitor updating = NullProgressMonitor.INSTANCE;
        if (this.sideBand) {
            SideBandProgressMonitor pm = new SideBandProgressMonitor(this.msgOut);
            pm.setDelayStart(250L, TimeUnit.MILLISECONDS);
            updating = pm;
        }
        BatchRefUpdate batch = this.db.getRefDatabase().newBatchUpdate();
        batch.setAllowNonFastForwards(this.isAllowNonFastForwards());
        batch.setAtomic(this.isAtomic());
        batch.setRefLogIdent(this.getRefLogIdent());
        batch.setRefLogMessage("push", true);
        batch.addCommand(toApply);
        try {
            batch.setPushCertificate(this.getPushCertificate());
            batch.execute(this.walk, updating);
        }
        catch (IOException err) {
            for (ReceiveCommand cmd : toApply) {
                if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                cmd.reject(err);
            }
        }
    }

    protected void sendStatusReport(boolean forClient, Throwable unpackError, Reporter out) throws IOException {
        if (unpackError != null) {
            out.sendString("unpack error " + unpackError.getMessage());
            if (forClient) {
                for (ReceiveCommand cmd : this.commands) {
                    out.sendString("ng " + cmd.getRefName() + " n/a (unpacker error)");
                }
            }
            return;
        }
        if (forClient) {
            out.sendString("unpack ok");
        }
        block12: for (ReceiveCommand cmd : this.commands) {
            if (cmd.getResult() == ReceiveCommand.Result.OK) {
                if (!forClient) continue;
                out.sendString("ok " + cmd.getRefName());
                continue;
            }
            StringBuilder r = new StringBuilder();
            if (forClient) {
                r.append("ng ").append(cmd.getRefName()).append(" ");
            } else {
                r.append(" ! [rejected] ").append(cmd.getRefName()).append(" (");
            }
            switch (cmd.getResult()) {
                case NOT_ATTEMPTED: {
                    r.append("server bug; ref not processed");
                    break;
                }
                case REJECTED_NOCREATE: {
                    r.append("creation prohibited");
                    break;
                }
                case REJECTED_NODELETE: {
                    r.append("deletion prohibited");
                    break;
                }
                case REJECTED_NONFASTFORWARD: {
                    r.append("non-fast forward");
                    break;
                }
                case REJECTED_CURRENT_BRANCH: {
                    r.append("branch is currently checked out");
                    break;
                }
                case REJECTED_MISSING_OBJECT: {
                    if (cmd.getMessage() == null) {
                        r.append("missing object(s)");
                        break;
                    }
                    if (cmd.getMessage().length() == 40) {
                        r.append("object ");
                        r.append(cmd.getMessage());
                        r.append(" missing");
                        break;
                    }
                    r.append(cmd.getMessage());
                    break;
                }
                case REJECTED_OTHER_REASON: {
                    if (cmd.getMessage() == null) {
                        r.append("unspecified reason");
                        break;
                    }
                    r.append(cmd.getMessage());
                    break;
                }
                case LOCK_FAILURE: {
                    r.append("failed to lock");
                    break;
                }
                case OK: {
                    continue block12;
                }
            }
            if (!forClient) {
                r.append(")");
            }
            out.sendString(r.toString());
        }
    }

    protected void close() throws IOException {
        if (this.sideBand) {
            ((SideBandOutputStream)this.msgOut).flushBuffer();
            ((SideBandOutputStream)this.rawOut).flushBuffer();
            PacketLineOut plo = new PacketLineOut(this.origOut);
            plo.setFlushOnEnd(false);
            plo.end();
        }
        if (this.biDirectionalPipe) {
            if (!this.sideBand && this.msgOut != null) {
                this.msgOut.flush();
            }
            this.rawOut.flush();
        }
    }

    protected void release() throws IOException {
        this.walk.close();
        this.unlockPack();
        this.timeoutIn = null;
        this.rawIn = null;
        this.rawOut = null;
        this.msgOut = null;
        this.pckIn = null;
        this.pckOut = null;
        this.refs = null;
        this.commands = null;
        if (this.timer != null) {
            try {
                this.timer.terminate();
            }
            finally {
                this.timer = null;
            }
        }
    }

    public static class FirstLine {
        private final String line;
        private final Set<String> capabilities;

        public FirstLine(String line) {
            HashSet<String> caps = new HashSet<String>();
            int nul = line.indexOf(0);
            if (nul >= 0) {
                for (String c : line.substring(nul + 1).split(" ")) {
                    caps.add(c);
                }
                this.line = line.substring(0, nul);
            } else {
                this.line = line;
            }
            this.capabilities = Collections.unmodifiableSet(caps);
        }

        public String getLine() {
            return this.line;
        }

        public Set<String> getCapabilities() {
            return this.capabilities;
        }
    }

    class MessageOutputWrapper
    extends OutputStream {
        MessageOutputWrapper() {
        }

        @Override
        public void write(int ch) {
            if (BaseReceivePack.this.msgOut != null) {
                try {
                    BaseReceivePack.this.msgOut.write(ch);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void write(byte[] b, int off, int len) {
            if (BaseReceivePack.this.msgOut != null) {
                try {
                    BaseReceivePack.this.msgOut.write(b, off, len);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void write(byte[] b) {
            this.write(b, 0, b.length);
        }

        @Override
        public void flush() {
            if (BaseReceivePack.this.msgOut != null) {
                try {
                    BaseReceivePack.this.msgOut.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected static class ReceiveConfig {
        final boolean allowCreates;
        final boolean allowDeletes;
        final boolean allowNonFastForwards;
        final boolean allowOfsDelta;
        final boolean allowPushOptions;
        final long maxCommandBytes;
        final long maxDiscardBytes;
        final SignedPushConfig signedPush;

        ReceiveConfig(Config config) {
            this.allowCreates = true;
            this.allowDeletes = !config.getBoolean("receive", "denydeletes", false);
            this.allowNonFastForwards = !config.getBoolean("receive", "denynonfastforwards", false);
            this.allowOfsDelta = config.getBoolean("repack", "usedeltabaseoffset", true);
            this.allowPushOptions = config.getBoolean("receive", "pushoptions", false);
            this.maxCommandBytes = config.getLong("receive", "maxCommandBytes", 0x300000L);
            this.maxDiscardBytes = config.getLong("receive", "maxCommandDiscardBytes", -1L);
            this.signedPush = SignedPushConfig.KEY.parse(config);
        }
    }

    static abstract class Reporter {
        Reporter() {
        }

        abstract void sendString(String var1) throws IOException;
    }
}

