/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.Assert;
import org.custommonkey.xmlunit.DoctypeInputStream;
import org.custommonkey.xmlunit.DoctypeReader;
import org.custommonkey.xmlunit.NodeInputStream;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.exceptions.ConfigurationException;
import org.custommonkey.xmlunit.exceptions.XMLUnitRuntimeException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Validator
extends DefaultHandler
implements ErrorHandler {
    private final InputSource validationInputSource;
    private final SAXParser parser;
    private final StringBuffer messages = new StringBuffer();
    private final boolean usingDoctypeReader;
    private Boolean isValid = null;

    protected Validator(InputSource inputSource, boolean usingDoctypeReader) throws SAXException, ConfigurationException {
        this(inputSource, null, usingDoctypeReader);
    }

    protected Validator(InputSource inputSource, String systemId, boolean usingDoctypeReader) throws SAXException, ConfigurationException {
        SAXParserFactory factory = XMLUnit.getSAXParserFactory();
        factory.setValidating(true);
        try {
            this.parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw new ConfigurationException(ex);
        }
        this.validationInputSource = inputSource;
        if (systemId != null) {
            this.validationInputSource.setSystemId(systemId);
        }
        this.usingDoctypeReader = usingDoctypeReader;
    }

    public Validator(Document document, String systemID, String doctype) throws SAXException, ConfigurationException {
        this(new InputStreamReader(new NodeInputStream(document)), systemID, doctype);
    }

    public Validator(Reader readerForValidation) throws SAXException, ConfigurationException {
        this(readerForValidation, null);
    }

    public Validator(String stringForValidation) throws SAXException, ConfigurationException {
        this(new StringReader(stringForValidation));
    }

    public Validator(InputSource sourceForValidation) throws SAXException, ConfigurationException {
        this(sourceForValidation, null);
    }

    public Validator(Reader readerForValidation, String systemID) throws SAXException, ConfigurationException {
        this(new InputSource(readerForValidation), systemID, readerForValidation instanceof DoctypeReader);
    }

    public Validator(String stringForValidation, String systemID) throws SAXException, ConfigurationException {
        this(new StringReader(stringForValidation), systemID);
    }

    public Validator(InputSource sourceForValidation, String systemID) throws SAXException, ConfigurationException {
        this(sourceForValidation, systemID, false);
    }

    public Validator(InputSource sourceForValidation, String systemID, String doctype) throws SAXException, ConfigurationException {
        this(sourceForValidation.getCharacterStream() != null ? new InputSource(new DoctypeReader(sourceForValidation.getCharacterStream(), doctype, systemID)) : new InputSource(new DoctypeInputStream(sourceForValidation.getByteStream(), sourceForValidation.getEncoding(), doctype, systemID)), systemID, true);
    }

    public Validator(Reader readerForValidation, String systemID, String doctype) throws SAXException, ConfigurationException {
        this(readerForValidation instanceof DoctypeReader ? readerForValidation : new DoctypeReader(readerForValidation, doctype, systemID), systemID);
    }

    public void useXMLSchema(boolean use) throws SAXException {
        boolean tryXercesProperties = false;
        try {
            if (use) {
                this.parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            }
        }
        catch (SAXNotRecognizedException e) {
            tryXercesProperties = true;
        }
        catch (SAXNotSupportedException e) {
            tryXercesProperties = true;
        }
        if (tryXercesProperties) {
            this.parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/schema", use);
            this.parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/dynamic", use);
        }
    }

    public boolean isValid() {
        this.validate();
        return this.isValid;
    }

    public void assertIsValid() {
        if (!this.isValid()) {
            Assert.fail((String)this.messages.toString());
        }
    }

    private StringBuffer appendMessage(StringBuffer toAppendTo) {
        if (this.isValid()) {
            return toAppendTo.append("[valid]");
        }
        return toAppendTo.append(this.messages);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString()).append(':');
        return this.appendMessage(buf).toString();
    }

    private void validate() {
        if (this.isValid != null) {
            return;
        }
        try {
            this.parser.parse(this.validationInputSource, (DefaultHandler)this);
        }
        catch (SAXException e) {
            this.parserException(e);
        }
        catch (IOException e) {
            this.parserException(e);
        }
        if (this.isValid == null) {
            this.isValid = Boolean.TRUE;
        } else if (this.usingDoctypeReader) {
            try {
                this.messages.append("\nContent was: ").append(Validator.getOriginalContent(this.validationInputSource));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void parserException(Exception e) {
        this.invalidate(e.getMessage());
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.errorHandlerException(exception);
    }

    public void error(SAXParseException exception) throws SAXException {
        this.errorHandlerException(exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.errorHandlerException(exception);
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (this.validationInputSource.getSystemId() != null) {
            return new InputSource(this.validationInputSource.getSystemId());
        }
        InputSource s2 = null;
        try {
            if (XMLUnit.getControlEntityResolver() != null) {
                s2 = XMLUnit.getControlEntityResolver().resolveEntity(publicId, systemId);
            }
        }
        catch (SAXException e) {
            throw new XMLUnitRuntimeException("failed to resolve entity: " + publicId, e);
        }
        catch (IOException e) {
            throw new XMLUnitRuntimeException("failed to resolve entity: " + publicId, e);
        }
        if (s2 != null) {
            return s2;
        }
        if (systemId != null) {
            return new InputSource(systemId);
        }
        return null;
    }

    private void errorHandlerException(SAXParseException e) {
        String msg = "At line " + e.getLineNumber() + ", column: " + e.getColumnNumber() + " ==> " + e.getMessage();
        if (!msg.endsWith("\n")) {
            msg = msg + "\n";
        }
        this.invalidate(msg);
    }

    private void invalidate(String message) {
        this.isValid = Boolean.FALSE;
        this.messages.append(message).append(' ');
    }

    public void setJAXP12SchemaSource(Object schemaSource) throws SAXException {
        this.parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaSource);
    }

    private static String getOriginalContent(InputSource s2) throws IOException {
        return s2.getCharacterStream() instanceof DoctypeReader ? ((DoctypeReader)s2.getCharacterStream()).getContent() : ((DoctypeInputStream)s2.getByteStream()).getContent(s2.getEncoding());
    }
}

