/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.nio.BufferedData;
import org.apache.hc.core5.http.impl.nio.ClientHttp1IOEventHandler;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexer;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.nio.command.CommandSupport;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.impl.nio.ClientH2IOEventHandler;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.ssl.ApplicationProtocol;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.SocketTimeoutExceptionFactory;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

@Internal
public class ClientHttpProtocolNegotiator
implements HttpConnectionEventHandler {
    static final byte[] PREFACE = new byte[]{80, 82, 73, 32, 42, 32, 72, 84, 84, 80, 47, 50, 46, 48, 13, 10, 13, 10, 83, 77, 13, 10, 13, 10};
    private final ProtocolIOSession ioSession;
    private final ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory;
    private final ClientH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final HttpVersionPolicy versionPolicy;
    private final AtomicReference<HttpConnectionEventHandler> protocolHandlerRef;
    private volatile ByteBuffer preface;
    private volatile BufferedData inBuf;

    public ClientHttpProtocolNegotiator(ProtocolIOSession ioSession, ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory, ClientH2StreamMultiplexerFactory http2StreamHandlerFactory, HttpVersionPolicy versionPolicy) {
        this.ioSession = Args.notNull(ioSession, "I/O session");
        this.http1StreamHandlerFactory = Args.notNull(http1StreamHandlerFactory, "HTTP/1.1 stream handler factory");
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.protocolHandlerRef = new AtomicReference<Object>(null);
    }

    private void startHttp1(IOSession session) {
        ClientHttp1StreamDuplexer http1StreamHandler = this.http1StreamHandlerFactory.create(this.ioSession);
        ClientHttp1IOEventHandler protocolHandler = new ClientHttp1IOEventHandler(http1StreamHandler);
        try {
            this.ioSession.upgrade(protocolHandler);
            this.protocolHandlerRef.set(protocolHandler);
            protocolHandler.connected(session);
            if (this.inBuf != null) {
                protocolHandler.inputReady(session, this.inBuf.data());
                this.inBuf.clear();
            }
        }
        catch (Exception ex) {
            protocolHandler.exception(session, ex);
            session.close(CloseMode.IMMEDIATE);
        }
    }

    private void startHttp2(IOSession session) {
        ClientH2StreamMultiplexer streamMultiplexer = this.http2StreamHandlerFactory.create(this.ioSession);
        ClientH2IOEventHandler protocolHandler = new ClientH2IOEventHandler(streamMultiplexer);
        try {
            this.ioSession.upgrade(protocolHandler);
            this.protocolHandlerRef.set(protocolHandler);
            protocolHandler.connected(session);
            if (this.inBuf != null) {
                protocolHandler.inputReady(session, this.inBuf.data());
                this.inBuf.clear();
            }
        }
        catch (Exception ex) {
            protocolHandler.exception(session, ex);
            session.close(CloseMode.IMMEDIATE);
        }
    }

    private void writeOutPreface(IOSession session) throws IOException {
        if (this.preface.hasRemaining()) {
            IOSession channel = session;
            channel.write(this.preface);
        }
        if (!this.preface.hasRemaining()) {
            session.clearEvent(4);
            this.startHttp2(session);
        } else {
            session.setEvent(4);
        }
    }

    @Override
    public void connected(IOSession session) throws IOException {
        switch (this.versionPolicy) {
            case NEGOTIATE: {
                TlsDetails tlsDetails = this.ioSession.getTlsDetails();
                if (tlsDetails == null || !ApplicationProtocol.HTTP_2.id.equals(tlsDetails.getApplicationProtocol())) break;
                this.preface = ByteBuffer.wrap(PREFACE);
                break;
            }
            case FORCE_HTTP_2: {
                this.preface = ByteBuffer.wrap(PREFACE);
            }
        }
        if (this.preface == null) {
            this.startHttp1(session);
        } else {
            this.writeOutPreface(session);
        }
    }

    @Override
    public void inputReady(IOSession session, ByteBuffer src) throws IOException {
        if (src != null) {
            if (this.inBuf == null) {
                this.inBuf = BufferedData.allocate(src.remaining());
            }
            this.inBuf.put(src);
        }
        this.outputReady(session);
    }

    @Override
    public void outputReady(IOSession session) throws IOException {
        if (this.preface != null) {
            this.writeOutPreface(session);
        } else {
            session.close(CloseMode.GRACEFUL);
        }
    }

    @Override
    public void timeout(IOSession session, Timeout timeout) {
        this.exception(session, SocketTimeoutExceptionFactory.create(timeout));
    }

    @Override
    public void exception(IOSession session, Exception cause) {
        session.close(CloseMode.IMMEDIATE);
        HttpConnectionEventHandler protocolHandler = this.protocolHandlerRef.get();
        if (protocolHandler != null) {
            protocolHandler.exception(session, cause);
        } else {
            CommandSupport.failCommands(session, cause);
        }
    }

    @Override
    public void disconnected(IOSession session) {
        HttpConnectionEventHandler protocolHandler = this.protocolHandlerRef.getAndSet(null);
        if (protocolHandler != null) {
            protocolHandler.disconnected(this.ioSession);
        } else {
            CommandSupport.cancelCommands(session);
        }
    }

    @Override
    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        HttpConnectionEventHandler protocolHandler = this.protocolHandlerRef.get();
        return protocolHandler != null ? protocolHandler.getEndpointDetails() : null;
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        HttpConnectionEventHandler protocolHandler = this.protocolHandlerRef.get();
        return protocolHandler != null ? protocolHandler.getProtocolVersion() : null;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public boolean isOpen() {
        return this.ioSession.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.ioSession.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioSession.close(closeMode);
    }

    public String toString() {
        return "[versionPolicy=" + (Object)((Object)this.versionPolicy) + ']';
    }
}

