/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.tests;

import io.sealights.onpremise.agents.commons.SlCollections;
import io.sealights.onpremise.agents.commons.instrument.types.AnnotationInfo;
import io.sealights.onpremise.agents.commons.instrument.types.ClassSignature;
import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import io.sealights.onpremise.agents.tests.IgnoredTest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public final class IgnoredTestsUtils {
    public static final String JUNIT4_IGNORE_ANNOTATION = "org.junit.Ignore";
    public static final String JUNIT5_IGNORE_ANNOTATION = "org.junit.jupiter.api.Disabled";
    public static final String TESTNG_IGNORE_ANNOTATION = "org.testng.annotations.Ignore";
    public static final String TESTNG_TEST_ANNOTATION = "org.testng.annotations.Test";
    private static final Set<String> knownIgnoreAnnotations = SlCollections.unmodifiableSet("org.testng.annotations.Ignore", "org.junit.Ignore", "org.junit.jupiter.api.Disabled");
    private static final Set<String> knownTestAnnotations = SlCollections.unmodifiableSet("org.testng.annotations.Test");
    public static final String CUSTOMER_IGNORE = "CUSTOMER";
    public static final String TIA_IGNORE = "TIA";
    public static final String METHOD_IGNORE = "method";
    public static final String CLASS_IGNORE = "class";

    public static Set<IgnoredTest> extractFromClassSignature(ClassSignature classSignature) {
        if (classSignature == null) {
            return Collections.emptySet();
        }
        HashSet<IgnoredTest> result = new HashSet<IgnoredTest>();
        List<AnnotationInfo> classAnnotations = classSignature.getAnnotations();
        String classTestName = classSignature.getClassName();
        IgnoredTestsUtils.tryFindIgnoredTestByAnnotations(classTestName, CLASS_IGNORE, classAnnotations).ifPresent(result::add);
        List<MethodSignature> methods = classSignature.getMethods();
        if (methods == null || methods.isEmpty()) {
            return result;
        }
        for (MethodSignature method : methods) {
            String methodTestName = method.getClassName() + "." + method.getName();
            IgnoredTestsUtils.tryFindIgnoredTestByAnnotations(methodTestName, METHOD_IGNORE, method.getAnnotations()).ifPresent(result::add);
        }
        return result;
    }

    private static Optional<IgnoredTest> tryFindIgnoredTestByAnnotations(String testName, String ignoreScope, Collection<AnnotationInfo> annotations) {
        if (annotations != null) {
            for (AnnotationInfo annotation : annotations) {
                if (!IgnoredTestsUtils.isIgnoredByMethodAnnotation(annotation)) continue;
                String valueStr = IgnoredTestsUtils.extractStringValue(annotation, "value");
                IgnoredTest ignoredTest = IgnoredTestsUtils.createCustomerIgnoredTest(testName, ignoreScope, annotation.getClassName(), valueStr);
                return Optional.of(ignoredTest);
            }
        }
        return Optional.empty();
    }

    private static boolean isIgnoredByMethodAnnotation(AnnotationInfo annotation) {
        return knownIgnoreAnnotations.contains(annotation.getClassName()) || knownTestAnnotations.contains(annotation.getClassName()) && !IgnoredTestsUtils.extractBooleanValue(annotation, "enabled");
    }

    private static String extractStringValue(AnnotationInfo annotationInfo, String propertyName) {
        return Optional.ofNullable(annotationInfo).map(AnnotationInfo::getSimpleValues).map(m3 -> m3.get(propertyName)).map(Object::toString).orElse(null);
    }

    private static boolean extractBooleanValue(AnnotationInfo annotationInfo, String propertyName) {
        String strValue = IgnoredTestsUtils.extractStringValue(annotationInfo, propertyName);
        return strValue == null || Boolean.parseBoolean(strValue);
    }

    public static IgnoredTest createTiaIgnoredTest(String name) {
        return new IgnoredTest(name, TIA_IGNORE, METHOD_IGNORE, null, null);
    }

    public static IgnoredTest createCustomerIgnoredTest(String name, String ignoreScope, String annotationClass, String annotationValue) {
        return new IgnoredTest(name, CUSTOMER_IGNORE, ignoreScope, annotationClass, annotationValue);
    }

    public static boolean isCustomerIgnored(IgnoredTest ignoredTest) {
        return CUSTOMER_IGNORE.equals(ignoredTest.getReason());
    }

    public static boolean isTiaIgnored(IgnoredTest ignoredTest) {
        return TIA_IGNORE.equals(ignoredTest.getReason());
    }

    @Generated
    private IgnoredTestsUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

