/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.tcs.core;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.time.sync.TimeClockServiceHandler;
import io.sealights.onpremise.agents.tcs.config.TimeClockConfiguration;
import io.sealights.onpremise.agents.tcs.config.TimeClockSettings;
import lombok.Generated;
import org.slf4j.Logger;

public class TimeClockManager {
    private static final Logger LOG = LogFactory.getLogger(TimeClockManager.class);
    private TimeClockServiceHandler timeClockServiceHandler;
    private TimeClockConfiguration configuration;

    public TimeClockManager(TimeClockConfiguration configuration, TimeClockServiceHandler timeClockServiceHandler) {
        this.configuration = configuration;
        TimeClockSettings timeClockSettings = configuration.getTimeClockSettings();
        if (null != timeClockSettings) {
            timeClockServiceHandler.setTimeSyncIntervalSec(timeClockSettings.getSyncIntervalSec());
            timeClockServiceHandler.setEnabled(timeClockSettings.getEnabled());
        } else {
            timeClockServiceHandler.setEnabled(false);
        }
    }

    public TimeClockManager(TimeClockConfiguration configuration) {
        this(configuration, new TimeClockServiceHandler(configuration.getToken(), configuration.getServer(), configuration.getProxy()));
    }

    @Generated
    public void setTimeClockServiceHandler(TimeClockServiceHandler timeClockServiceHandler) {
        this.timeClockServiceHandler = timeClockServiceHandler;
    }

    @Generated
    public TimeClockConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setConfiguration(TimeClockConfiguration configuration) {
        this.configuration = configuration;
    }
}

