/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.logs.service.proxy.api;

import io.sealights.onpremise.agents.infra.configuration.SLAgentConfiguration;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLServiceProxy;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.logs.service.proxy.api.LogData;
import io.sealights.onpremise.agents.logs.service.proxy.api.LogsServiceProxy;
import io.sealights.onpremise.agents.logs.service.proxy.api.SubmitLogsRequest;
import org.slf4j.Logger;

public class LogsServiceProxyHandler
extends SLServiceProxy
implements LogsServiceProxy {
    private static final Logger LOG = LogFactory.getLogger(LogsServiceProxyHandler.class);
    public static final String LOG_SUBMISSION_URL = "/v2/logsubmission/";
    private String url = this.getServer() + "/v2/logsubmission/";

    public LogsServiceProxyHandler(SLAgentConfiguration configuration) {
        super(configuration.getToken(), configuration.getServer(), configuration.getProxy(), true);
    }

    @Override
    public boolean sendLogs(String customerId, String appName, LogData log) {
        return this.sendLogs(customerId, appName, null, log);
    }

    @Override
    public boolean sendLogs(String customerId, String appName, String labId, LogData log) {
        return this.submittLogs(new SubmitLogsRequest(customerId, appName, labId, log));
    }

    protected boolean submittLogs(SubmitLogsRequest request) {
        try {
            LOG.info("Submitting logs");
            this.getHttpClient().sendPostRequest(new SLHttpRequest<Void>(this.getTag(), this.url, request, Void.class));
            LOG.info("Done submitting logs.");
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed while trying to submit logs. Error:", e);
            return false;
        }
    }

    @Override
    public String getTag() {
        return "LS";
    }
}

