/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.logs.config;

import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.infra.logging.LogConfiguration;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import lombok.Generated;

public class LogbackLogConfiguration
extends LogConfiguration {
    public static final String DEFAULT_LOGS_FOLDER = "logs";
    public static final int DEFAULT_FILES_COUNT = 10;
    public static final int DEFAULT_FILES_SIZE_MB = 10;
    public static final int DEFAULT_SEND_INTERVAL_MINS = 5;
    public static final int DEFAULT_SEND_MAX_SIZE_MB = 10;
    private static int SECS_60 = 60;
    private Boolean appendToFile = null;
    private Boolean sendLogsOnShutdown = null;
    private String logFileName = null;
    private String logsFolder = null;
    private Integer fileCount = null;
    private Integer logLimitInMB = null;
    private Integer sendIntervalMins = null;
    private Integer sendIntervalSecs = null;
    private Integer sendMaxSizeMB = null;

    public void autoConfigureSendLogsByTimer() {
        if (this.getSendIntervalMins() == 0) {
            this.setSendIntervalMins(5);
        }
        this.autoConfigure();
        this.setSendLogsOnShutdown(false);
    }

    public void autoConfigureSendLogsOnShutdown() {
        if (this.getSendIntervalMins() > 0) {
            this.autoConfigureSendLogsByTimer();
            return;
        }
        if (this.isSendLogsOnShutdown().booleanValue()) {
            this.setAppendToFile(true);
        }
    }

    public void autoConfigure() {
        if (this.isSendLogsOnTimer() || this.isAppendToConsole() || this.isAppendToFile()) {
            this.forceLevelNotOff();
        } else if (!(this.isSendLogsOnTimer() || this.isAppendToConsole() || this.isAppendToFile())) {
            this.setLogLevel(Level.OFF);
        }
        LogFactory.setConsoleLogLevel(this.getLogLevel());
    }

    public void setAppendToConsole(boolean value) {
        super.setAppendToConsole(value);
        this.autoConfigure();
    }

    public boolean isAppendToFile() {
        if (this.appendToFile != null) {
            return this.appendToFile;
        }
        return Boolean.parseBoolean(System.getProperty("sl.log.toFile"));
    }

    public void setAppendToFile(boolean value) {
        this.appendToFile = value;
        this.autoConfigure();
    }

    public Boolean isSendLogsOnShutdown() {
        if (this.sendLogsOnShutdown != null) {
            return this.sendLogsOnShutdown;
        }
        return Boolean.parseBoolean(System.getProperty("sl.log.sendLogsOnShutdown"));
    }

    public boolean isSendLogsOnTimer() {
        return this.getSendIntervalSecs() > 0;
    }

    public String getLogFileName() {
        if (!StringUtils.isNullOrEmpty(this.logFileName)) {
            return this.logFileName;
        }
        String value = SystemPropertiesHelper.getStrProperty("sl.log.filename", "sl-java-agent");
        return StringUtils.removeWrappingSingleQuotes(value);
    }

    public String getLogsFolder() {
        if (!StringUtils.isNullOrEmpty(this.logsFolder)) {
            return this.logsFolder;
        }
        String value = SystemPropertiesHelper.getStrProperty("sl.log.folder", DEFAULT_LOGS_FOLDER);
        return StringUtils.removeWrappingSingleQuotes(value);
    }

    public int getFileCount() {
        if (this.fileCount != null) {
            return this.fileCount;
        }
        return SystemPropertiesHelper.getIntProperty("sl.log.count", 10);
    }

    public int getLogLimitInMB() {
        if (this.logLimitInMB != null) {
            return this.logLimitInMB;
        }
        return SystemPropertiesHelper.getIntProperty("sl.log.limit", 10);
    }

    @Override
    public Level getLogLevel() {
        Level forced = super.getLogLevel();
        Level propertyValue = this.levelPropertyValue();
        if (forced != null) {
            return forced;
        }
        return propertyValue;
    }

    private Level levelPropertyValue() {
        String propValue = System.getProperty("sl.log.level");
        if (StringUtils.isNullOrEmpty(propValue)) {
            return Level.OFF;
        }
        if (Level.get(propValue) != null) {
            return Level.get(propValue);
        }
        return Level.INFO;
    }

    public void setSendIntervalMins(int value) {
        this.sendIntervalMins = value;
        this.sendIntervalSecs = value * SECS_60;
    }

    public int getSendIntervalMins() {
        if (this.sendIntervalMins != null) {
            return this.sendIntervalMins;
        }
        return SystemPropertiesHelper.getIntProperty("sl.log.sendIntervalMin", 0);
    }

    public int getSendIntervalSecs() {
        if (this.sendIntervalSecs != null) {
            return this.sendIntervalSecs;
        }
        int intervalInMins = this.getSendIntervalMins();
        if (intervalInMins > 0) {
            return intervalInMins * SECS_60;
        }
        return 0;
    }

    public int getSendMaxSizeMB() {
        if (this.sendMaxSizeMB != null) {
            return this.sendMaxSizeMB;
        }
        return SystemPropertiesHelper.getIntProperty("sl.log.sendMaxSizeMB", 10);
    }

    @Override
    public String toString() {
        return String.format("(appendToConsole=%s, appendToFile=%s, sendIntervalMins=%s, sendLogsOnShutdown=%s, logFileName=%s, logsFolder=%s, fileCount=%s, logLimitInMB=%s, logLevel=%s, sendMaxEntries=%s)", this.isAppendToConsole(), this.isAppendToFile(), this.getSendIntervalMins(), this.isSendLogsOnShutdown(), this.getLogFileName(), this.getLogsFolder(), this.getFileCount(), this.getLogLimitInMB(), this.getLogLevel().getName(), this.getSendMaxSizeMB());
    }

    private void forceLevelNotOff() {
        Level current = this.getLogLevel();
        if (current == null || Level.OFF == current) {
            this.setLogLevel(Level.INFO);
        }
    }

    public void setLogLevel(String logLevel) {
        this.setLogLevel(Level.get(logLevel));
    }

    @Generated
    public void setSendLogsOnShutdown(Boolean sendLogsOnShutdown) {
        this.sendLogsOnShutdown = sendLogsOnShutdown;
    }

    @Generated
    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    @Generated
    public void setLogsFolder(String logsFolder) {
        this.logsFolder = logsFolder;
    }

    @Generated
    public void setFileCount(Integer fileCount) {
        this.fileCount = fileCount;
    }

    @Generated
    public void setLogLimitInMB(Integer logLimitInMB) {
        this.logLimitInMB = logLimitInMB;
    }

    @Generated
    public void setSendIntervalSecs(Integer sendIntervalSecs) {
        this.sendIntervalSecs = sendIntervalSecs;
    }

    @Generated
    public void setSendMaxSizeMB(Integer sendMaxSizeMB) {
        this.sendMaxSizeMB = sendMaxSizeMB;
    }
}

