/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import io.sealights.onpremise.agents.infra.configuration.SLAgentConfiguration;
import io.sealights.onpremise.agents.infra.utils.threads.TaskScheduler;
import io.sealights.onpremise.agents.logback.LogbackConfigurator;
import io.sealights.onpremise.agents.logs.service.proxy.api.LogData;
import io.sealights.onpremise.agents.logs.service.proxy.api.LogsServiceProxy;
import io.sealights.onpremise.agents.logs.service.proxy.api.LogsServiceProxyHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;

public class SLAppender
extends UnsynchronizedAppenderBase<ILoggingEvent>
implements TaskScheduler.Task {
    private static final String SL_LOGS = "sl-logs";
    private static int BYTES_TO_MB = 1024000;
    private String customerId;
    private String appName;
    private String labId;
    private LogsServiceProxy logsServiceProxy;
    private LogsFlushTimerHolder logsFlushTimerHolder = new LogsFlushTimerHolder();
    private volatile int logsSizeInBytes = 0;
    private final ReentrantLock lock = new ReentrantLock(false);
    private List<String> logs = new ArrayList<String>();
    private Encoder<ILoggingEvent> encoder;

    public void configureAndStart(String name, Encoder<ILoggingEvent> encoder, LoggerContext lc) {
        this.setName(name);
        this.setContext(lc);
        this.setEncoder(encoder);
        this.start();
    }

    @Override
    public void start() {
        if (this.encoder == null) {
            this.addError("No encoder set for the appender named [" + this.name + "]. ");
            return;
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initLogServiceProxy(SLAgentConfiguration configuration, String customerId, String appName, String labId) {
        this.lock.lock();
        try {
            this.customerId = customerId;
            this.appName = appName;
            this.labId = labId;
            if (this.logsServiceProxy == null) {
                this.logsServiceProxy = new LogsServiceProxyHandler(configuration);
            }
            this.startFlushTimer();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            super.stop();
            if (this.logsFlushTimerHolder.timerExists()) {
                this.logsFlushTimerHolder.getTimer().stop();
                this.sendLogs();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void append(ILoggingEvent eventObject) {
        if (!this.isStarted() || !this.isSendLogsRelevant()) {
            return;
        }
        this.appendLog(eventObject);
    }

    protected void appendLog(ILoggingEvent eventObject) {
        this.lock.lock();
        try {
            String newLine = new String(this.encoder.encode(eventObject));
            this.logs.add(newLine);
            this.logsSizeInBytes += newLine.length() * 2;
            if (this.logsSizeInBytes >= LogbackConfigurator.getLogConfiguration().getSendMaxSizeMB() * BYTES_TO_MB) {
                this.logsFlushTimerHolder.getTimer().cancelTask();
                this.sendLogs();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void startFlushTimer() {
        if (this.isSendLogsRelevant()) {
            this.logsFlushTimerHolder.getTimer().assignTaskForRepeatedExecution(this, TaskScheduler.toMillis(LogbackConfigurator.getLogConfiguration().getSendIntervalSecs()));
        }
    }

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    @Override
    public void run() {
        this.lock.lock();
        try {
            this.sendLogs();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void sendLogs() {
        if (this.logsServiceProxy == null) {
            return;
        }
        ArrayList<String> flushed = new ArrayList<String>(this.logs);
        this.logs.clear();
        this.logsSizeInBytes = 0;
        this.logsServiceProxy.sendLogs(this.customerId, this.appName, this.labId, new LogData(flushed));
    }

    public boolean isLogEmpty() {
        return 0 == this.logsSizeInBytes;
    }

    @Override
    public String getName() {
        return SL_LOGS;
    }

    private boolean isSendLogsRelevant() {
        return LogbackConfigurator.getLogConfiguration().isSendLogsOnTimer();
    }

    @Generated
    public void setLogsServiceProxy(LogsServiceProxy logsServiceProxy) {
        this.logsServiceProxy = logsServiceProxy;
    }

    @Generated
    public int getLogsSizeInBytes() {
        return this.logsSizeInBytes;
    }

    static class LogsFlushTimerHolder {
        private TaskScheduler logsFlushTimer;

        LogsFlushTimerHolder() {
        }

        boolean timerExists() {
            return this.logsFlushTimer != null;
        }

        TaskScheduler getTimer() {
            if (this.logsFlushTimer == null) {
                this.logsFlushTimer = new TaskScheduler(SLAppender.SL_LOGS);
            }
            return this.logsFlushTimer;
        }
    }
}

