/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.util.StatusPrinter;
import io.sealights.onpremise.agents.infra.env.AgentId;
import io.sealights.onpremise.agents.infra.environment.DefaultEnvironmentInfo;
import io.sealights.onpremise.agents.infra.http.client.HttpClientLogging;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.logging.LogManager;
import io.sealights.onpremise.agents.logback.LogbackConfigurator;
import io.sealights.onpremise.agents.logback.SlTurboFilters;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackLogManager
implements LogManager {
    public static void activateSLLogbackConfiguration() {
        LogbackConfigurator.activateSLLogbackConfiguration();
    }

    public static void start() {
        try {
            LogbackLogManager.activateSLLogbackConfiguration();
            LogFactory.bindLogManager(new LogbackLogManager());
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            loggerContext.addTurboFilter(new SlTurboFilters.AlwaysPrintTurboFilter());
            LogbackConfigurator.autoConfigure();
            StatusPrinter.printInCaseOfErrorsOrWarnings(loggerContext);
            loggerContext.getLogger("ROOT").info(String.format("SL-Logging for Agent [version='%s'] [AgentID='%s'] started with configuration: %s", DefaultEnvironmentInfo.getAgentVersion(), AgentId.getAgentId(), LogbackConfigurator.getLogConfiguration()));
            StatusPrinter.print(loggerContext);
            HttpClientLogging.configureLogsDebug();
            LogbackLogManager.restoreAppLogbackConfiguration();
        }
        catch (Exception e) {
            System.err.println("Failed to start logback, logs are disabled; error:" + e);
        }
    }

    public static void stop() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.stop();
    }

    @Override
    public void setThreadContext() {
    }

    @Override
    public Logger getFrameworkLogger(Class<?> clazz) {
        return this.getFrameworkLogger(clazz.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Logger getFrameworkLogger(String name) {
        LogbackLogManager.activateSLLogbackConfiguration();
        Logger logger = null;
        try {
            ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
            if (loggerFactory instanceof LoggerContext) {
                logger = loggerFactory.getLogger(name);
                LogbackConfigurator.INSTANCE.configureLogger((LoggerContext)loggerFactory, logger);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            LogbackLogManager.restoreAppLogbackConfiguration();
        }
        return logger;
    }

    @Override
    public io.sealights.onpremise.agents.infra.logging.Level getConfiguredLogLevel() {
        return LogbackConfigurator.getLogConfiguration().getLogLevel();
    }

    @Override
    public void httpLogsDebugOn(String rootLoggerName) {
        Logger logger = this.getFrameworkLogger(rootLoggerName);
        LogbackConfigurator.INSTANCE.setLoggerLevel((ch.qos.logback.classic.Logger)logger, Level.DEBUG);
    }

    @Override
    public void httpLogsDebugOff(String rootLoggerName) {
        Logger logger = this.getFrameworkLogger(rootLoggerName);
        LogbackConfigurator.INSTANCE.setLoggerLevel((ch.qos.logback.classic.Logger)logger, Level.OFF);
    }

    protected static void restoreAppLogbackConfiguration() {
        LogbackConfigurator.clearSLLogbackConfiguration();
    }
}

