/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.rolling.RollingFileAppender;
import io.sealights.onpremise.agents.infra.configuration.SLAgentConfiguration;
import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.logback.CustomContextInitilizer;
import io.sealights.onpremise.agents.logback.SLAppender;
import io.sealights.onpremise.agents.logs.config.LogbackLogConfiguration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LogbackConfigurator {
    INSTANCE;

    public static final String SEALIGHTS_MARKER = "SEALIGHTS";
    public static final String SL_LOGBACK = "sl.logback";
    private LogbackLogConfiguration logConfig = new LogbackLogConfiguration();
    private RollingFileAppender<ILoggingEvent> rollingFileAppender = new RollingFileAppender();
    private ConsoleAppender<ILoggingEvent> consoleAppender = new ConsoleAppender();
    private SLAppender slAppender = new SLAppender();
    private AtomicBoolean isShutdown = new AtomicBoolean();

    public static void activateSLLogbackConfiguration() {
        SystemPropertiesHelper.setProperty(SL_LOGBACK, true);
    }

    public static void clearSLLogbackConfiguration() {
        System.clearProperty(SL_LOGBACK);
    }

    public static void tryConfigureForSendLogsOnShutdown() {
        LogbackConfigurator.INSTANCE.logConfig.autoConfigureSendLogsOnShutdown();
    }

    public static void autoConfigureSendLogsByTimer() {
        LogbackConfigurator.INSTANCE.logConfig.autoConfigureSendLogsByTimer();
    }

    public static void autoConfigure() {
        LogbackConfigurator.INSTANCE.logConfig.autoConfigure();
    }

    public static LogbackLogConfiguration getLogConfiguration() {
        return LogbackConfigurator.INSTANCE.logConfig;
    }

    public static void setLogConfiguration(LogbackLogConfiguration logConfig) {
        LogbackConfigurator.INSTANCE.logConfig = logConfig;
    }

    public static RollingFileAppender<ILoggingEvent> getRollingFileAppender() {
        return LogbackConfigurator.INSTANCE.rollingFileAppender;
    }

    public static ConsoleAppender<ILoggingEvent> getConsoleAppender() {
        return LogbackConfigurator.INSTANCE.consoleAppender;
    }

    public static SLAppender getSLAppender() {
        return LogbackConfigurator.INSTANCE.slAppender;
    }

    public static void initSLAppender(SLAgentConfiguration configuration, String customerId, String appName) {
        LogbackConfigurator.initSLAppender(configuration, customerId, appName, null);
    }

    public static void initSLAppender(SLAgentConfiguration configuration, String customerId, String appName, String labId) {
        LogbackConfigurator.INSTANCE.slAppender.initLogServiceProxy(configuration, customerId, appName, labId);
        Runtime.getRuntime().addShutdownHook(INSTANCE.createShutdownHook());
    }

    public static boolean isLogEnable(Level level) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger logger = context.getLogger("ROOT");
        if (level == Level.ERROR && logger.isErrorEnabled()) {
            return true;
        }
        if (level == Level.INFO && logger.isInfoEnabled()) {
            return true;
        }
        if (level == Level.DEBUG && logger.isDebugEnabled()) {
            return true;
        }
        if (level == Level.TRACE && logger.isTraceEnabled()) {
            return true;
        }
        return level == Level.WARN && logger.isWarnEnabled();
    }

    public void configureLogger(LoggerContext loggerContext, Logger logger) {
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)logger;
        new CustomContextInitilizer().configureLogger(loggerContext, logbackLogger, false);
    }

    public void setLevel(Level level) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        List<ch.qos.logback.classic.Logger> loggers = loggerContext.getLoggerList();
        for (ch.qos.logback.classic.Logger logger : loggers) {
            logger.setLevel(level);
        }
    }

    public void setLogsOff() {
        this.setLevel(Level.OFF);
    }

    public void setLogLevel(String loggerName, Level level) {
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger(loggerName);
        this.setLoggerLevel(logger, level);
    }

    public void setLoggerLevel(ch.qos.logback.classic.Logger logger, Level level) {
        logger.setLevel(level);
    }

    public void setLogLevel(Class<?> loggerClass, Level level) {
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger(loggerClass.getSimpleName());
        this.setLoggerLevel(logger, level);
    }

    public Level getRootLevel() {
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
        return root.getLevel();
    }

    public void setConsoleAppenderForTestsOnly(ConsoleAppender<ILoggingEvent> testableConsoleAppender) {
        this.consoleAppender = testableConsoleAppender;
    }

    public static Level mapToLogbackLevel(io.sealights.onpremise.agents.infra.logging.Level slLevel) {
        return Level.toLevel(slLevel.getName());
    }

    private Thread createShutdownHook() {
        Thread shutdownHook = new Thread(){

            @Override
            public void run() {
                Thread.currentThread().setName("Logback ShutdownHook");
                boolean isAlreadyShutdown = LogbackConfigurator.this.isShutdown.getAndSet(true);
                if (!isAlreadyShutdown) {
                    LogbackConfigurator.this.slAppender.stop();
                }
            }
        };
        return shutdownHook;
    }
}

