/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.logback;

import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.util.FileSize;
import io.sealights.onpremise.agents.infra.env.AgentId;
import io.sealights.onpremise.agents.infra.environment.DefaultEnvironmentInfo;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import io.sealights.onpremise.agents.logback.CustomFilePatternLayout;
import io.sealights.onpremise.agents.logback.LogbackConfigurator;
import io.sealights.onpremise.agents.logback.SLAppender;
import io.sealights.onpremise.agents.logback.converters.PidConverter;
import io.sealights.onpremise.agents.logback.converters.SlMarkerConverter;
import io.sealights.onpremise.agents.logback.converters.ThreadIdConverter;
import io.sealights.onpremise.agents.logs.config.LogbackLogConfiguration;
import java.util.HashMap;
import java.util.Map;

public class CustomContextInitilizer
extends BasicConfigurator {
    public static final String CONSOLE_APPENDER = "Console";
    public static final String FILE_APPENDER = "File";
    public static final String SL_APPENDER = "SLLog";
    private static final String SYSOUT = "System.out";
    private static final String PATTERN_FMT_FULL = "[%slMaker] %d{ISO8601} %-5p [%pid|%-12.12t|%tid] %C{35} : %m%n";
    public static final String LOGGER_START_MESSAGE_FMT = "SL-Logging for Agent [version='%s'] [AgentID='%s'] started with configuration: %s";

    private RollingFileAppender<ILoggingEvent> getRollingFileAppender() {
        return LogbackConfigurator.getRollingFileAppender();
    }

    private ConsoleAppender<ILoggingEvent> getConsoleAppender() {
        return LogbackConfigurator.getConsoleAppender();
    }

    private SLAppender getSLAppender() {
        return LogbackConfigurator.getSLAppender();
    }

    @Override
    public void configure(LoggerContext lc) {
        lc.stop();
        lc.reset();
        Logger rootLogger = lc.getLogger("ROOT");
        this.configureLogger(lc, rootLogger, true);
        String statusMsg = String.format(LOGGER_START_MESSAGE_FMT, DefaultEnvironmentInfo.getAgentVersion(), AgentId.getAgentId(), LogbackConfigurator.getLogConfiguration());
        this.addStatus(new InfoStatus(statusMsg, this));
    }

    public void configureLogger(LoggerContext lc, Logger logger, boolean additive) {
        LogbackLogConfiguration logConfig = LogbackConfigurator.getLogConfiguration();
        Level globalLogLevel = LogbackConfigurator.mapToLogbackLevel(logConfig.getLogLevel());
        Level logLevelForLogger = CustomContextInitilizer.getLogLevelForLogger(logger, globalLogLevel);
        logger.setLevel(logLevelForLogger);
        logger.setAdditive(additive);
        this.addConsoleAppender(lc, logger);
        this.addFileAppender(lc, logger, logConfig);
        this.addSLAppender(lc, logger, logConfig);
    }

    private static Level getLogLevelForLogger(Logger logger, Level globalLogLevel) {
        String loggerName = logger.getName();
        String loggerLevelSystemPropertyName = "sl.log." + loggerName + ".level";
        String loggerLevelSystemPropertyValue = System.getProperty(loggerLevelSystemPropertyName);
        return Level.toLevel(loggerLevelSystemPropertyValue, globalLogLevel);
    }

    protected void addConsoleAppender(LoggerContext lc, Logger logger) {
        if (logger.getAppender(CONSOLE_APPENDER) != null) {
            return;
        }
        this.configureAndStartConsoleAppender(lc);
        logger.addAppender((Appender<ILoggingEvent>)this.getConsoleAppender());
    }

    protected void addFileAppender(LoggerContext lc, Logger logger, LogbackLogConfiguration logConfig) {
        if (!logConfig.isAppendToFile() || logger.getAppender(FILE_APPENDER) != null) {
            return;
        }
        this.configureAndStartFileAppender(lc, logConfig);
        logger.addAppender((Appender<ILoggingEvent>)this.getRollingFileAppender());
    }

    protected void addSLAppender(LoggerContext lc, Logger logger, LogbackLogConfiguration logConfig) {
        if (logConfig.getSendIntervalMins() <= 0 || logger.getAppender(SL_APPENDER) != null) {
            return;
        }
        if (!this.getSLAppender().isStarted()) {
            this.getSLAppender().configureAndStart(SL_APPENDER, this.getEncoder(lc, false), lc);
        }
        logger.addAppender(this.getSLAppender());
    }

    protected void configureAndStartConsoleAppender(LoggerContext lc) {
        if (!this.getConsoleAppender().isStarted()) {
            this.getConsoleAppender().setName(CONSOLE_APPENDER);
            this.getConsoleAppender().setTarget(SYSOUT);
            this.getConsoleAppender().setEncoder(this.getEncoder(lc, false));
            this.getConsoleAppender().setContext(lc);
            this.getConsoleAppender().start();
        }
    }

    protected void configureAndStartFileAppender(LoggerContext lc, LogbackLogConfiguration logConfig) {
        if (!this.getRollingFileAppender().isStarted()) {
            String fileName = PathUtils.join(logConfig.getLogsFolder(), logConfig.getLogFileName());
            this.getRollingFileAppender().setName(FILE_APPENDER);
            this.getRollingFileAppender().setFile(fileName + ".log");
            this.getRollingFileAppender().setContext(lc);
            this.getRollingFileAppender().setAppend(true);
            this.getRollingFileAppender().setPrudent(false);
            FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
            rollingPolicy.setContext(lc);
            rollingPolicy.setParent(this.getRollingFileAppender());
            rollingPolicy.setMinIndex(1);
            rollingPolicy.setMaxIndex(logConfig.getFileCount());
            rollingPolicy.setFileNamePattern(fileName + "-%i.log");
            this.getRollingFileAppender().setRollingPolicy(rollingPolicy);
            SizeBasedTriggeringPolicy triggerPolicy = new SizeBasedTriggeringPolicy();
            triggerPolicy.setMaxFileSize(FileSize.valueOf(logConfig.getLogLimitInMB() + "MB"));
            this.getRollingFileAppender().setTriggeringPolicy(triggerPolicy);
            triggerPolicy.start();
            rollingPolicy.start();
            this.getRollingFileAppender().setEncoder(this.getEncoder(lc, true));
            this.getRollingFileAppender().start();
        }
    }

    protected Encoder<ILoggingEvent> getEncoder(LoggerContext loggerContext, boolean fileLayout) {
        LayoutWrappingEncoder<ILoggingEvent> encoder = new LayoutWrappingEncoder<ILoggingEvent>();
        PatternLayout layout = fileLayout ? new CustomFilePatternLayout() : new PatternLayout();
        Map<String, String> ruleRegistry = this.getRuleRegistry(loggerContext);
        this.registerConverter(ruleRegistry, "pid", PidConverter.class);
        this.registerConverter(ruleRegistry, "slMaker", SlMarkerConverter.class);
        this.registerConverter(ruleRegistry, "tid", ThreadIdConverter.class);
        layout.setContext(loggerContext);
        layout.setPattern(PATTERN_FMT_FULL);
        layout.setOutputPatternAsHeader(false);
        layout.start();
        encoder.setLayout(layout);
        encoder.start();
        return encoder;
    }

    private void registerConverter(Map<String, String> ruleRegistry, String key, Class<? extends Converter> converter) {
        ruleRegistry.put(key, converter.getName());
    }

    private Map<String, String> getRuleRegistry(LoggerContext loggerContext) {
        Object ruleRegistryObj = loggerContext.getObject("PATTERN_RULE_REGISTRY");
        Map ruleRegistry = ruleRegistryObj != null && ruleRegistryObj instanceof Map ? (Map)ruleRegistryObj : new HashMap();
        loggerContext.putObject("PATTERN_RULE_REGISTRY", ruleRegistry);
        return ruleRegistry;
    }
}

