/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.instrument.filters.custom;

import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import io.sealights.onpremise.agents.infra.env.DefaultDirs;
import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.instrument.filters.custom.CustomMethodExcludeRules;
import java.beans.ConstructorProperties;
import java.io.File;
import lombok.Generated;
import org.slf4j.Logger;

public class CustomRulesReader {
    private static Logger LOG = LogFactory.getLogger(CustomRulesReader.class);
    public static final String FILE_NOT_EXISTS_FMT = "Custom rules file '%s' not exists in working directory '%s'";
    public static final String FILE_READ_ERROR_FMT = "Failed to read custom rules file '%s' in working directory '%s'";
    private String rulesFileName;

    public CustomMethodExcludeRules read() {
        if (StringUtils.isNullOrEmpty(this.rulesFileName)) {
            LOG.info("No rules file was provided; customer rules filter is empty");
            return this.returnEmptyRules();
        }
        LOG.info("Loading customer rules from '{}', working directory: '{}'", (Object)this.rulesFileName, (Object)DefaultDirs.WORKING_DIR);
        File rulesFile = new File(this.rulesFileName);
        if (rulesFile.exists()) {
            return this.readFile(rulesFile);
        }
        AgentLifeCycle.notifyWarningMsg(String.format(FILE_NOT_EXISTS_FMT, this.rulesFileName, DefaultDirs.WORKING_DIR));
        return this.returnEmptyRules();
    }

    private CustomMethodExcludeRules readFile(File rulesFile) {
        try {
            CustomMethodExcludeRules customerRules = JsonObjectMapper.toObject(rulesFile, CustomMethodExcludeRules.class);
            if (customerRules != null) {
                LOG.info("Loaded from file {}", (Object)customerRules);
                return customerRules;
            }
            AgentLifeCycle.notifyWarningMsg(String.format(FILE_READ_ERROR_FMT, this.rulesFileName, DefaultDirs.WORKING_DIR));
        }
        catch (Exception e) {
            AgentLifeCycle.notifyException(this.getClass(), String.format(FILE_READ_ERROR_FMT, this.rulesFileName, DefaultDirs.WORKING_DIR), e);
        }
        return this.returnEmptyRules();
    }

    private CustomMethodExcludeRules returnEmptyRules() {
        return new CustomMethodExcludeRules();
    }

    @ConstructorProperties(value={"rulesFileName"})
    @Generated
    public CustomRulesReader(String rulesFileName) {
        this.rulesFileName = rulesFileName;
    }
}

