/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.instrument.filters.custom;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.instrument.filters.custom.AggregatedGroupRules;
import io.sealights.onpremise.agents.instrument.filters.custom.CustomMethodExcludeRules;
import io.sealights.onpremise.agents.instrument.filters.custom.CustomRegexEscaper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;

public final class CustomRulesProcessor {
    private static Logger LOG = LogFactory.getLogger(CustomRulesProcessor.class);
    protected static final String PIPE = "|";
    protected static final String VALUE_FMT = "(%s)";
    protected static final String WILDCARD = ".*";

    public static List<AggregatedGroupRules> execute(CustomMethodExcludeRules customerRules) {
        ArrayList<AggregatedGroupRules> aggregatedRules = new ArrayList<AggregatedGroupRules>();
        if (customerRules != null) {
            for (CustomMethodExcludeRules.GroupRules groupRules : customerRules.getGroups()) {
                aggregatedRules.add(CustomRulesProcessor.convertGroupRules(groupRules));
            }
            LOG.info("created custom exclude aggregated rules:{}", (Object)aggregatedRules);
        }
        return aggregatedRules;
    }

    protected static AggregatedGroupRules convertGroupRules(CustomMethodExcludeRules.GroupRules groupRules) {
        return new GroupRulesConverter(groupRules).convert();
    }

    protected static String mergePatterns(List<String> patterns, boolean isExactMatch) {
        if (patterns == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String p : patterns) {
            if (!isFirst) {
                builder.append(PIPE);
            } else {
                isFirst = false;
            }
            if (isExactMatch) {
                builder.append(String.format(VALUE_FMT, Pattern.quote(p)));
                continue;
            }
            builder.append(String.format(VALUE_FMT, p));
        }
        return builder.toString();
    }

    protected static String mergeExactAndRegexPatterns(List<String> exactPatterns, List<String> regexPatterns) {
        return CustomRulesProcessor.joinRegexes(CustomRulesProcessor.mergePatterns(exactPatterns, true), CustomRulesProcessor.mergePatterns(regexPatterns, false));
    }

    protected static String joinRegexes(String string1, String string2) {
        if (StringUtils.isNullOrEmpty(string1)) {
            return CustomRulesProcessor.replaceByEmptyStringIfNull(string2);
        }
        if (StringUtils.isNullOrEmpty(string2)) {
            return CustomRulesProcessor.replaceByEmptyStringIfNull(string1);
        }
        return string1 + PIPE + string2;
    }

    private static String replaceByEmptyStringIfNull(String value) {
        return value == null ? "" : value;
    }

    @Generated
    private CustomRulesProcessor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class GroupRulesConverter {
        private CustomMethodExcludeRules.GroupRules groupRules;
        private List<String> classNames;
        private List<String> escapedIncludesRegexes;
        private List<String> escapedExcludesRegexes;

        GroupRulesConverter(CustomMethodExcludeRules.GroupRules groupRules) {
            this.groupRules = groupRules;
        }

        AggregatedGroupRules convert() {
            this.prepareNormalizedInput();
            return new AggregatedGroupRules(CustomRulesProcessor.mergePatterns(this.classNames, false), CustomRulesProcessor.mergeExactAndRegexPatterns(this.groupRules.getIncludesExact(), this.escapedIncludesRegexes), CustomRulesProcessor.mergeExactAndRegexPatterns(this.groupRules.getExcludesExact(), this.escapedExcludesRegexes));
        }

        private void prepareNormalizedInput() {
            this.escapeRulesBrackets();
            if (!this.groupRules.hasClassNames()) {
                this.classNames = new ArrayList<String>();
                this.classNames.add(CustomRulesProcessor.WILDCARD);
            } else {
                this.classNames = CustomRegexEscaper.escapeNestedClassesNames(this.groupRules.getClassNames());
            }
        }

        private void escapeRulesBrackets() {
            if (this.groupRules.getIncludesRegex() != null) {
                this.escapedIncludesRegexes = CustomRegexEscaper.escapeMethodsBrackets(this.groupRules.getIncludesRegex());
            }
            if (this.groupRules.getExcludesRegex() != null) {
                this.escapedExcludesRegexes = CustomRegexEscaper.escapeMethodsBrackets(this.groupRules.getExcludesRegex());
            }
        }

        @Generated
        public CustomMethodExcludeRules.GroupRules getGroupRules() {
            return this.groupRules;
        }

        @Generated
        public List<String> getClassNames() {
            return this.classNames;
        }

        @Generated
        public List<String> getEscapedIncludesRegexes() {
            return this.escapedIncludesRegexes;
        }

        @Generated
        public List<String> getEscapedExcludesRegexes() {
            return this.escapedExcludesRegexes;
        }

        @Generated
        public void setGroupRules(CustomMethodExcludeRules.GroupRules groupRules) {
            this.groupRules = groupRules;
        }

        @Generated
        public void setClassNames(List<String> classNames) {
            this.classNames = classNames;
        }

        @Generated
        public void setEscapedIncludesRegexes(List<String> escapedIncludesRegexes) {
            this.escapedIncludesRegexes = escapedIncludesRegexes;
        }

        @Generated
        public void setEscapedExcludesRegexes(List<String> escapedExcludesRegexes) {
            this.escapedExcludesRegexes = escapedExcludesRegexes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupRulesConverter)) {
                return false;
            }
            GroupRulesConverter other = (GroupRulesConverter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CustomMethodExcludeRules.GroupRules this$groupRules = this.getGroupRules();
            CustomMethodExcludeRules.GroupRules other$groupRules = other.getGroupRules();
            if (this$groupRules == null ? other$groupRules != null : !((Object)this$groupRules).equals(other$groupRules)) {
                return false;
            }
            List<String> this$classNames = this.getClassNames();
            List<String> other$classNames = other.getClassNames();
            if (this$classNames == null ? other$classNames != null : !((Object)this$classNames).equals(other$classNames)) {
                return false;
            }
            List<String> this$escapedIncludesRegexes = this.getEscapedIncludesRegexes();
            List<String> other$escapedIncludesRegexes = other.getEscapedIncludesRegexes();
            if (this$escapedIncludesRegexes == null ? other$escapedIncludesRegexes != null : !((Object)this$escapedIncludesRegexes).equals(other$escapedIncludesRegexes)) {
                return false;
            }
            List<String> this$escapedExcludesRegexes = this.getEscapedExcludesRegexes();
            List<String> other$escapedExcludesRegexes = other.getEscapedExcludesRegexes();
            return !(this$escapedExcludesRegexes == null ? other$escapedExcludesRegexes != null : !((Object)this$escapedExcludesRegexes).equals(other$escapedExcludesRegexes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GroupRulesConverter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CustomMethodExcludeRules.GroupRules $groupRules = this.getGroupRules();
            result = result * 59 + ($groupRules == null ? 43 : ((Object)$groupRules).hashCode());
            List<String> $classNames = this.getClassNames();
            result = result * 59 + ($classNames == null ? 43 : ((Object)$classNames).hashCode());
            List<String> $escapedIncludesRegexes = this.getEscapedIncludesRegexes();
            result = result * 59 + ($escapedIncludesRegexes == null ? 43 : ((Object)$escapedIncludesRegexes).hashCode());
            List<String> $escapedExcludesRegexes = this.getEscapedExcludesRegexes();
            result = result * 59 + ($escapedExcludesRegexes == null ? 43 : ((Object)$escapedExcludesRegexes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CustomRulesProcessor.GroupRulesConverter(groupRules=" + this.getGroupRules() + ", classNames=" + this.getClassNames() + ", escapedIncludesRegexes=" + this.getEscapedIncludesRegexes() + ", escapedExcludesRegexes=" + this.getEscapedExcludesRegexes() + ")";
        }
    }
}

