/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.instrument.filters.custom;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.instrument.filters.custom.AggregatedGroupRules;
import io.sealights.onpremise.agents.instrument.filters.custom.CustomMethodExcludeRules;
import io.sealights.onpremise.agents.instrument.filters.custom.CustomRulesProcessor;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;

public class CustomRulesFilter {
    private static Logger LOG = LogFactory.getLogger(CustomRulesFilter.class);
    private CustomMethodExcludeRules customRules;
    private List<AggregatedGroupRules> aggregatedGroupRules;

    public CustomRulesFilter(CustomMethodExcludeRules customerRules) {
        this.customRules = customerRules;
        this.aggregatedGroupRules = CustomRulesProcessor.execute(customerRules);
    }

    public boolean isExcludedMethod(String className, String methodSignature) {
        if (this.isEmpty()) {
            return false;
        }
        AggregatedGroupRules groupRules = this.findClassRules(className);
        if (groupRules == null) {
            return false;
        }
        if (this.isRegexMatch(groupRules.getIncludesRegex(), methodSignature)) {
            LOG.debug("method '{}.{}' matches includes regex - will NOT be excluded", (Object)className, (Object)methodSignature);
            return false;
        }
        if (this.isRegexMatch(groupRules.getExcludesRegex(), methodSignature)) {
            LOG.debug("method '{}.{}' will be excluded", (Object)className, (Object)methodSignature);
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.customRules == null || this.customRules.isEmpty();
    }

    protected AggregatedGroupRules findClassRules(String className) {
        for (AggregatedGroupRules group : this.aggregatedGroupRules) {
            if (!this.isRegexMatch(group.getClassNamesRegex(), className)) continue;
            return group;
        }
        return null;
    }

    private boolean isRegexMatch(String pattern, String value) {
        return Pattern.matches(pattern, value);
    }

    @Generated
    public CustomMethodExcludeRules getCustomRules() {
        return this.customRules;
    }

    @Generated
    public List<AggregatedGroupRules> getAggregatedGroupRules() {
        return this.aggregatedGroupRules;
    }

    @Generated
    public void setCustomRules(CustomMethodExcludeRules customRules) {
        this.customRules = customRules;
    }

    @Generated
    public void setAggregatedGroupRules(List<AggregatedGroupRules> aggregatedGroupRules) {
        this.aggregatedGroupRules = aggregatedGroupRules;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomRulesFilter)) {
            return false;
        }
        CustomRulesFilter other = (CustomRulesFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CustomMethodExcludeRules this$customRules = this.getCustomRules();
        CustomMethodExcludeRules other$customRules = other.getCustomRules();
        if (this$customRules == null ? other$customRules != null : !((Object)this$customRules).equals(other$customRules)) {
            return false;
        }
        List<AggregatedGroupRules> this$aggregatedGroupRules = this.getAggregatedGroupRules();
        List<AggregatedGroupRules> other$aggregatedGroupRules = other.getAggregatedGroupRules();
        return !(this$aggregatedGroupRules == null ? other$aggregatedGroupRules != null : !((Object)this$aggregatedGroupRules).equals(other$aggregatedGroupRules));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomRulesFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CustomMethodExcludeRules $customRules = this.getCustomRules();
        result = result * 59 + ($customRules == null ? 43 : ((Object)$customRules).hashCode());
        List<AggregatedGroupRules> $aggregatedGroupRules = this.getAggregatedGroupRules();
        result = result * 59 + ($aggregatedGroupRules == null ? 43 : ((Object)$aggregatedGroupRules).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CustomRulesFilter(customRules=" + this.getCustomRules() + ", aggregatedGroupRules=" + this.getAggregatedGroupRules() + ")";
    }
}

