/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.instrument.filters.custom;

import java.util.ArrayList;
import java.util.List;

public class CustomRegexEscaper {
    private static final char DOLLAR = '$';
    private static final char OPEN_BRACKET = '(';
    private static final char CLOSE_BRACKET = ')';
    private static final String ESCAPE_OPEN_BRACKET = "\\(";
    private static final String ESCAPE_CLOSE_BRACKET = "\\)";
    private static final String ESCAPE = "\\";

    public static List<String> escapeMethodsBrackets(List<String> regexes) {
        ArrayList<String> completedRegexes = new ArrayList<String>();
        for (String regex : regexes) {
            completedRegexes.add(CustomRegexEscaper.escapeMethodBrackets(regex));
        }
        return completedRegexes;
    }

    public static List<String> escapeNestedClassesNames(List<String> regexes) {
        ArrayList<String> completedRegexes = new ArrayList<String>();
        for (String regex : regexes) {
            completedRegexes.add(CustomRegexEscaper.escapeNestedClassName(regex));
        }
        return completedRegexes;
    }

    protected static String escapeMethodBrackets(String regex) {
        int openBracketCtr = 0;
        StringBuilder escaped = new StringBuilder();
        block4: for (int i = 0; i < regex.length(); ++i) {
            char currentChar = regex.charAt(i);
            switch (currentChar) {
                case '(': {
                    if (openBracketCtr++ == 0) {
                        escaped.append(ESCAPE_OPEN_BRACKET);
                        continue block4;
                    }
                    escaped.append(currentChar);
                    continue block4;
                }
                case ')': {
                    if (--openBracketCtr == 0) {
                        escaped.append(ESCAPE_CLOSE_BRACKET);
                        continue block4;
                    }
                    escaped.append(currentChar);
                    continue block4;
                }
                default: {
                    escaped.append(currentChar);
                }
            }
        }
        return escaped.toString();
    }

    protected static String escapeNestedClassName(String regex) {
        return CustomRegexEscaper.escapeChar(regex.substring(0, regex.length() - 1), '$') + regex.charAt(regex.length() - 1);
    }

    protected static String escapeChar(String regex, char charToEsape) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < regex.length(); ++i) {
            char currentChar = regex.charAt(i);
            if (currentChar == charToEsape) {
                escaped.append(ESCAPE);
            }
            escaped.append(currentChar);
        }
        return escaped.toString();
    }
}

