/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.instrument.filters;

import io.sealights.onpremise.agents.commons.instrument.visitors.KotlinMetadataExtractor;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.instrumentation.BytecodeMethodAccessHelper;
import java.util.List;
import kotlinx.metadata.Flag;
import kotlinx.metadata.KmConstructor;
import kotlinx.metadata.KmFunction;
import kotlinx.metadata.KmProperty;
import org.slf4j.Logger;

public class SkipMethodVisitFilters {

    public static interface SkipMethodVisitFilter {
        public boolean match(String var1, int var2, String var3);
    }

    public static class KotlinSkipMethodVisitFilter
    implements SkipMethodVisitFilter {
        private static Logger LOG = LogFactory.getLogger(KotlinSkipMethodVisitFilter.class);
        public static final String KOTLIN_METADATA_CLASS_NAME = "kotlin.Metadata";
        public static final String INVOKE_METHOD_NAME = "invoke";
        public static final String INVOKE_SUSPEND_METHOD_NAME = "invokeSuspend";
        public static final String GETTER_PREFIX = "get";
        public static final String SETTER_PREFIX = "set";
        private static final String DEFAULT_INTERFACE_IMPLEMENTATIONS_SUFFIX = "$DefaultImpls";
        private static final String COMPANION_CLASS_NAME_SUFFIX = "$Companion";
        private static final String METHOD_NAME_SEPARATOR = "$";
        private final KotlinMetadataExtractor.KotlinMetadata metadata;

        public KotlinSkipMethodVisitFilter(KotlinMetadataExtractor.KotlinMetadata kotlinMetadata) {
            this.metadata = kotlinMetadata;
        }

        @Override
        public boolean match(String className, int methodAccess, String methodName) {
            if (BytecodeMethodAccessHelper.isBridge(methodAccess) || BytecodeMethodAccessHelper.isAbstract(methodAccess)) {
                return true;
            }
            if (this.metadata == null) {
                LOG.error("Kotlin filtering used for class '{}' without kotlin.Metadata annotation.", (Object)className);
                return false;
            }
            if (this.metadata.isKotlinSyntheticClass()) {
                return !this.canHoldWrittenCode(methodName) && !this.isDefaultInterfaceImplementation(methodName, className);
            }
            return this.isCompanionObjectConstructor(className, methodName) || this.isGeneratedMethod(methodName);
        }

        private boolean isDefaultInterfaceImplementation(String methodName, String className) {
            return className.endsWith(DEFAULT_INTERFACE_IMPLEMENTATIONS_SUFFIX) && !methodName.contains(METHOD_NAME_SEPARATOR);
        }

        private boolean canHoldWrittenCode(String name) {
            return name.equals(INVOKE_METHOD_NAME) || name.equals(INVOKE_SUSPEND_METHOD_NAME);
        }

        private boolean isCompanionObjectConstructor(String className, String methodName) {
            return className.endsWith(COMPANION_CLASS_NAME_SUFFIX) && "<init>".equals(methodName);
        }

        private boolean isGeneratedMethod(String methodName) {
            List<KmFunction> functions = this.metadata.getFunctions();
            for (KmFunction fun : functions) {
                if (!fun.getName().equals(methodName)) continue;
                return Flag.Function.IS_SYNTHESIZED.invoke(fun.getFlags()) || Flag.Function.IS_DELEGATION.invoke(fun.getFlags());
            }
            if (methodName.equals("<init>")) {
                List<KmConstructor> constructors = this.metadata.getConstructors();
                return constructors.isEmpty();
            }
            List<KmProperty> properties = this.metadata.getProperties();
            for (KmProperty property : properties) {
                if (!methodName.equalsIgnoreCase(GETTER_PREFIX + property.getName()) && !methodName.equalsIgnoreCase(SETTER_PREFIX + property.getName())) continue;
                return false;
            }
            return true;
        }
    }

    public static class AspectJSkipMethodFilter
    implements SkipMethodVisitFilter {
        private static final String ECLIPSE_COMPILER_TABLE_SWITCH = "$SWITCH_TABLE$";

        @Override
        public boolean match(String className, int methodAccess, String methodName) {
            if (this.isSwitchTableMethod(methodAccess, methodName)) {
                return true;
            }
            return BytecodeMethodAccessHelper.isAbstract(methodAccess);
        }

        private boolean isSwitchTableMethod(int methodAccess, String methodName) {
            return BytecodeMethodAccessHelper.isSynthetic(methodAccess) && methodName.startsWith(ECLIPSE_COMPILER_TABLE_SWITCH);
        }
    }

    public static class DefaultSkipMethodVisitFilter
    implements SkipMethodVisitFilter {
        private static final String LAMBDA_METHOD_NAME_PREFIX = "lambda$";

        @Override
        public boolean match(String className, int methodAccess, String methodName) {
            return BytecodeMethodAccessHelper.isSynthetic(methodAccess) && !this.isLambda(methodName) || BytecodeMethodAccessHelper.isAbstract(methodAccess);
        }

        private boolean isLambda(String name) {
            return name.startsWith(LAMBDA_METHOD_NAME_PREFIX);
        }
    }
}

