/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.instrument.filters;

import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import io.sealights.onpremise.agents.commons.instrument.types.SourceLanguage;
import io.sealights.onpremise.agents.commons.instrument.utils.ClassSignatureFactory;
import io.sealights.onpremise.agents.commons.instrument.utils.MethodNamingHelper;
import io.sealights.onpremise.agents.commons.instrument.visitors.KotlinMetadataExtractor;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.instrument.filters.AnnotationExcludedMethodClassifier;
import io.sealights.onpremise.agents.instrument.filters.KotlinMethodClassifier;
import io.sealights.onpremise.agents.instrument.filters.MethodSignatureFilter;
import io.sealights.onpremise.agents.instrument.filters.custom.AggregatedGroupRules;
import io.sealights.onpremise.agents.instrument.filters.custom.CustomMethodExcludeRules;
import io.sealights.onpremise.agents.instrument.filters.custom.CustomRulesFilter;
import java.util.List;
import org.slf4j.Logger;

public class MethodSignatureExcludeFilter
implements MethodSignatureFilter {
    private static final Logger LOG = LogFactory.getLogger(MethodSignatureExcludeFilter.class);
    private static final KotlinMethodClassifier.KotlinJvmStaticFunctionFilter KOTLIN_JVM_STATIC_FUNCTION_FILTER = new KotlinMethodClassifier.KotlinJvmStaticFunctionFilter();
    private static final KotlinMethodClassifier.LinesNotNumberedFilter LINES_NOT_NUMBERED_FILTER = new KotlinMethodClassifier.LinesNotNumberedFilter();
    private KotlinMetadataExtractor.KotlinMetadata kotlinMetadata;
    private ConfigurationMethodFilter configFilter;
    private SourceLanguage sourceLanguage;
    private CustomExcludeMethodFilter customExcludeMethodFilter;

    public MethodSignatureExcludeFilter(SourceLanguage sourceLanguage, ClassSignatureFactory.SignatureConfiguration signatureConfiguration, CustomExcludeMethodFilter customExcludeMethodFilter, KotlinMetadataExtractor.KotlinMetadata kotlinMetadata) {
        this.configFilter = new ConfigurationMethodFilter(signatureConfiguration);
        this.customExcludeMethodFilter = customExcludeMethodFilter;
        this.sourceLanguage = sourceLanguage;
        this.kotlinMetadata = kotlinMetadata;
    }

    @Override
    public boolean match(MethodSignature signature) {
        if (this.isKotlinClass() && this.matchKotlinMethodExcludeFilter(signature)) {
            return true;
        }
        if (this.customExcludeMethodFilter != null && this.customExcludeMethodFilter.match(signature)) {
            return true;
        }
        return this.configFilter.match(signature);
    }

    private boolean matchKotlinMethodExcludeFilter(MethodSignature mSig) {
        return KOTLIN_JVM_STATIC_FUNCTION_FILTER.match(mSig) || this.isKotlinTechnicalInvoke(mSig);
    }

    private boolean isKotlinTechnicalInvoke(MethodSignature mSig) {
        return new KotlinMethodClassifier.KotlinInvokeFilter(this.kotlinMetadata).match(mSig) && LINES_NOT_NUMBERED_FILTER.match(mSig);
    }

    private boolean isKotlinClass() {
        return SourceLanguage.KOTLIN == this.sourceLanguage;
    }

    public static class CustomExcludeMethodFilter
    implements MethodSignatureFilter {
        private CustomRulesFilter customRulesFilter;

        public CustomExcludeMethodFilter(CustomMethodExcludeRules customerRules) {
            this.customRulesFilter = new CustomRulesFilter(customerRules);
        }

        @Override
        public boolean match(MethodSignature mSig) {
            return this.customRulesFilter.isExcludedMethod(mSig.getClassName(), MethodNamingHelper.buildDisplayNameForBuildMapping(mSig));
        }

        public boolean isEmpty() {
            return this.customRulesFilter.isEmpty();
        }

        public List<AggregatedGroupRules> getAggregatedRules() {
            return this.customRulesFilter.getAggregatedGroupRules();
        }
    }

    public static class ConfigurationMethodFilter
    implements MethodSignatureFilter {
        private ClassSignatureFactory.SignatureConfiguration configuration;
        private AnnotationExcludedMethodClassifier annotationExcludedMethodClassifier;

        public ConfigurationMethodFilter(ClassSignatureFactory.SignatureConfiguration configuration) {
            this.configuration = configuration;
            if (StringUtils.isNotEmpty(configuration.getMethodAnnotationsExcluded())) {
                this.annotationExcludedMethodClassifier = new AnnotationExcludedMethodClassifier(configuration.getMethodAnnotationsExcluded());
            }
        }

        @Override
        public boolean match(MethodSignature mSig) {
            if (!this.configuration.isWithConstructors() && mSig.isConstructor()) {
                LOG.debug("filtering constructor '{}.{}'", (Object)mSig.getClassName(), (Object)mSig.getName());
                return true;
            }
            if (!this.configuration.isWithGettersSetters() && mSig.isGetterOrSetter()) {
                LOG.debug("filtering getter/setter '{}.{}'", (Object)mSig.getClassName(), (Object)mSig.getName());
                return true;
            }
            if (this.configuration.isIgnoreMethodsWithoutLineNumbers() && (mSig.getStartLineNumber() == null || mSig.getStartLineNumber() == -1)) {
                LOG.debug("filtering method without line numbers '{}.{}'", (Object)mSig.getClassName(), (Object)mSig.getName());
                return true;
            }
            if (this.annotationExcludedMethodClassifier != null && this.annotationExcludedMethodClassifier.match(mSig)) {
                LOG.debug("filtering method excluded by annotation '{}.{}'", (Object)mSig.getClassName(), (Object)mSig.getName());
                return true;
            }
            if (this.configuration.isIgnoreAutoGeneratedCode() && mSig.isAutoGenerated()) {
                LOG.debug("filtering auto-generated method '{}.{}'", (Object)mSig.getClassName(), (Object)mSig.getName());
                return true;
            }
            return false;
        }
    }
}

