/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.instrument.filters;

import io.sealights.onpremise.agents.commons.instrument.types.AnnotationInfo;
import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import io.sealights.onpremise.agents.commons.instrument.visitors.KotlinMetadataExtractor;
import io.sealights.onpremise.agents.instrument.filters.MethodSignatureFilter;

public class KotlinMethodClassifier {

    public static class LinesNotNumberedFilter
    implements MethodSignatureFilter {
        @Override
        public boolean match(MethodSignature mSig) {
            return mSig.getStartLineNumber() == null;
        }
    }

    public static class KotlinInvokeFilter
    implements MethodSignatureFilter {
        private final KotlinMetadataExtractor.KotlinMetadata kotlinClassMetadata;

        public KotlinInvokeFilter(KotlinMetadataExtractor.KotlinMetadata kotlinClassMetadata) {
            this.kotlinClassMetadata = kotlinClassMetadata;
        }

        @Override
        public boolean match(MethodSignature mSig) {
            if (this.kotlinClassMetadata == null || !this.kotlinClassMetadata.isKotlinSyntheticClass()) {
                return false;
            }
            String methodName = mSig.getName();
            return methodName.equals("invoke") || methodName.equals("invokeSuspend");
        }
    }

    public static class KotlinJvmStaticFunctionFilter
    implements MethodSignatureFilter {
        private static final String COMPANION_CLASS_NAME_SUFFIX = "$Companion";
        private static final String JVM_STATIC_ANNOTATION_CLASS_NAME = "kotlin.jvm.JvmStatic";

        @Override
        public boolean match(MethodSignature mSig) {
            if (mSig.getClassName().endsWith(COMPANION_CLASS_NAME_SUFFIX)) {
                return false;
            }
            for (AnnotationInfo anInfo : mSig.getAnnotations()) {
                if (!anInfo.getClassName().equals(JVM_STATIC_ANNOTATION_CLASS_NAME)) continue;
                return true;
            }
            return false;
        }
    }
}

