/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.instrument.filters;

import io.sealights.onpremise.agents.commons.instrument.types.AnnotationInfo;
import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import io.sealights.onpremise.agents.commons.instrument.visitors.KotlinMetadataExtractor;
import io.sealights.onpremise.agents.instrument.filters.MethodSignatureFilter;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import kotlinx.metadata.Flag;
import kotlinx.metadata.KmFunction;
import kotlinx.metadata.KmProperty;
import lombok.Generated;

public class AutoGeneratedMethodClassifier
implements MethodSignatureFilter {
    private final KotlinMetadataExtractor.KotlinMetadata classMetadata;

    public AutoGeneratedMethodClassifier(KotlinMetadataExtractor.KotlinMetadata kotlinClassMetadata) {
        this.classMetadata = kotlinClassMetadata;
    }

    @Override
    public boolean match(MethodSignature mSig) {
        for (MethodSignatureFilter filter : this.allFilters()) {
            if (!filter.match(mSig)) continue;
            return true;
        }
        return false;
    }

    private List<MethodSignatureFilter> allFilters() {
        return Arrays.asList(new LombokGeneratedFilter(), new EnumClassFilter(), new PlayPropertyAccessorFilter(), new KotlinAutogeneratedGetterAndSetterFilter(this.classMetadata));
    }

    public static class KotlinAutogeneratedGetterAndSetterFilter
    implements MethodSignatureFilter {
        private final KotlinMetadataExtractor.KotlinMetadata classMetadata;

        public KotlinAutogeneratedGetterAndSetterFilter(KotlinMetadataExtractor.KotlinMetadata classMetadata) {
            this.classMetadata = classMetadata;
        }

        @Override
        public boolean match(MethodSignature mSig) {
            if (this.classMetadata == null) {
                return false;
            }
            String methodName = mSig.getName();
            if (!methodName.startsWith("get") && !methodName.startsWith("set")) {
                return false;
            }
            List<KmFunction> functions = this.classMetadata.getFunctions();
            for (KmFunction function : functions) {
                if (!methodName.equals(function.getName())) continue;
                return false;
            }
            List<KmProperty> properties = this.classMetadata.getProperties();
            for (KmProperty property : properties) {
                if (methodName.equalsIgnoreCase("get" + property.getName())) {
                    return !Flag.PropertyAccessor.IS_NOT_DEFAULT.invoke(property.getGetterFlags());
                }
                if (!methodName.equalsIgnoreCase("set" + property.getName())) continue;
                return !Flag.PropertyAccessor.IS_NOT_DEFAULT.invoke(property.getSetterFlags());
            }
            return false;
        }
    }

    public static class PlayPropertyAccessorFilter
    implements MethodSignatureFilter {
        private static final String PLAY_PROPERTY_ACCESSOR = "PlayPropertyAccessor";

        @Override
        public boolean match(MethodSignature mSig) {
            for (AnnotationInfo anInfo : mSig.getAnnotations()) {
                if (!anInfo.getName().contains(PLAY_PROPERTY_ACCESSOR)) continue;
                return true;
            }
            return false;
        }
    }

    public static class EnumClassMethodFilter
    implements MethodSignatureFilter {
        private int access;
        private String name;
        private String descriptor;

        public EnumClassMethodFilter(int access, String name) {
            this(access, name, null);
        }

        @Override
        public boolean match(MethodSignature mSig) {
            return mSig.getAccess() == this.access && mSig.getName().equals(this.name) && (this.descriptor == null || mSig.getDescriptor().equals(this.descriptor));
        }

        @Generated
        public int getAccess() {
            return this.access;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescriptor() {
            return this.descriptor;
        }

        @Generated
        public void setAccess(int access) {
            this.access = access;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setDescriptor(String descriptor) {
            this.descriptor = descriptor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumClassMethodFilter)) {
                return false;
            }
            EnumClassMethodFilter other = (EnumClassMethodFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAccess() != other.getAccess()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$descriptor = this.getDescriptor();
            String other$descriptor = other.getDescriptor();
            return !(this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EnumClassMethodFilter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAccess();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $descriptor = this.getDescriptor();
            result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AutoGeneratedMethodClassifier.EnumClassMethodFilter(access=" + this.getAccess() + ", name=" + this.getName() + ", descriptor=" + this.getDescriptor() + ")";
        }

        @ConstructorProperties(value={"access", "name", "descriptor"})
        @Generated
        public EnumClassMethodFilter(int access, String name, String descriptor) {
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
        }
    }

    public static class EnumClassFilter
    implements MethodSignatureFilter {
        private static final List<EnumClassMethodFilter> ENUM_FILTERS = Arrays.asList(new EnumClassMethodFilter(9, "values"), new EnumClassMethodFilter(9, "valueOf"), new EnumClassMethodFilter(8, "<clinit>", "()V"), new EnumClassMethodFilter(2, "<init>", "(Ljava/lang/String;I)V"));

        @Override
        public boolean match(MethodSignature mSig) {
            for (MethodSignatureFilter methodSignatureFilter : ENUM_FILTERS) {
                if (!methodSignatureFilter.match(mSig)) continue;
                return true;
            }
            return false;
        }
    }

    public static class LombokGeneratedFilter
    implements MethodSignatureFilter {
        private static final String GENERATED = "Generated";

        @Override
        public boolean match(MethodSignature mSig) {
            for (AnnotationInfo anInfo : mSig.getAnnotations()) {
                if (!anInfo.getName().contains(GENERATED)) continue;
                return true;
            }
            return false;
        }
    }
}

