/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.instrument.filters;

import io.sealights.onpremise.agents.commons.AnnotationsExcludedFilter;
import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.instrument.filters.MethodSignatureFilter;
import org.slf4j.Logger;

public class AnnotationExcludedMethodClassifier
implements MethodSignatureFilter {
    private static final Logger LOG = LogFactory.getLogger(AnnotationExcludedMethodClassifier.class);
    private final AnnotationsExcludedFilter annotationsExcludedFilter;

    public AnnotationExcludedMethodClassifier(String methodAnnotationsExcludedConfiguration) {
        this.annotationsExcludedFilter = new AnnotationsExcludedFilter(methodAnnotationsExcludedConfiguration);
    }

    @Override
    public boolean match(MethodSignature signature) {
        if (this.annotationsExcludedFilter.matchAny(signature.getAnnotations())) {
            LOG.info("method matched to be excluded by annotation {}.{}", (Object)signature.getClassName(), (Object)signature.getName());
            return true;
        }
        return false;
    }
}

