/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.version;

public class Version
implements Comparable<Version> {
    public static final int THIS_VERSION_NEWER = 1;
    public static final int THIS_VERSION_OLDER = -1;
    public static final int THIS_VERSION_EQUALS = 0;
    private String version;

    public final String get() {
        return this.version;
    }

    public final String toString() {
        return this.version;
    }

    public Version(String version) {
        if (version == null) {
            this.version = "0";
            return;
        }
        if (version.endsWith("-SNAPSHOT")) {
            version = version.replace("-SNAPSHOT", "");
        }
        this.version = !Version.isValidVersion(version) ? "0" : version;
    }

    public static boolean isValidVersion(String v) {
        return v != null && v.matches("[0-9]+(\\.[0-9]+).*");
    }

    @Override
    public int compareTo(Version other) {
        if (other == null) {
            return 1;
        }
        String[] thisParts = this.get().split("\\.");
        String[] otherParts = other.get().split("\\.");
        int length = Math.max(thisParts.length, otherParts.length);
        for (int i = 0; i < length; ++i) {
            int otherPart;
            int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
            int n = otherPart = i < otherParts.length ? Integer.parseInt(otherParts[i]) : 0;
            if (thisPart < otherPart) {
                return -1;
            }
            if (thisPart <= otherPart) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.compareTo((Version)other) == 0;
    }
}

