/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils.threads.httptask;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.Precondition;
import io.sealights.onpremise.agents.infra.utils.threads.TimeoutTimer;
import io.sealights.onpremise.agents.infra.utils.threads.httptask.InputArgs;
import io.sealights.onpremise.agents.infra.utils.threads.httptask.ScheduledHttpRequestSender;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class HttpRequestTask<T extends ScheduledHttpRequestSender<I>, I extends InputArgs>
extends TimeoutTimer {
    private static int DEFAULT_SEND_AWAIT_INTERVAL_MILLIS = 20;
    private static Logger LOG = LogFactory.getLogger(HttpRequestTask.class);
    private T requestSender;

    public HttpRequestTask(T requestSender) {
        this(requestSender, DEFAULT_SEND_AWAIT_INTERVAL_MILLIS);
    }

    public HttpRequestTask(T requestSender, int awaitMsecs) {
        super(awaitMsecs, TimeUnit.MILLISECONDS);
        this.requestSender = requestSender;
    }

    protected HttpRequestTask(int awaitMsecs) {
        this(null, awaitMsecs);
    }

    protected HttpRequestTask() {
        this(null);
    }

    @Override
    public synchronized void run() {
        Precondition.checkNotNull(this.requestSender);
        LOG.debug("Sending http request as scheduled task...");
        this.requestSender.sendRequest(this.getInputArgs());
    }

    public abstract I getInputArgs();

    @Generated
    public T getRequestSender() {
        return this.requestSender;
    }

    @Generated
    public void setRequestSender(T requestSender) {
        this.requestSender = requestSender;
    }

    @Override
    @Generated
    public String toString() {
        return "HttpRequestTask(requestSender=" + this.getRequestSender() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequestTask)) {
            return false;
        }
        HttpRequestTask other = (HttpRequestTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        T this$requestSender = this.getRequestSender();
        T other$requestSender = other.getRequestSender();
        return !(this$requestSender == null ? other$requestSender != null : !this$requestSender.equals(other$requestSender));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpRequestTask;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        T $requestSender = this.getRequestSender();
        result = result * 59 + ($requestSender == null ? 43 : $requestSender.hashCode());
        return result;
    }
}

