/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils.threads;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;

public class TaskScheduler {
    private static long SINGLE_EXEC_TASK_INTERVAL = -1L;
    private static Logger LOG = LogFactory.getLogger(TaskScheduler.class);
    private int shutdownAwaitSecs = 60;
    private ScheduledExecutorService scheduledExecutor;
    private volatile boolean isStopping = false;
    private ScheduledFuture<?> taskFutureExecution = null;
    private Task task = null;

    public static long toMillis(long intervalSec) {
        return intervalSec * 1000L;
    }

    public TaskScheduler(String threadPoolName) {
        this(TaskScheduler.createScheduledExecutorThread(threadPoolName));
    }

    public TaskScheduler(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
    }

    public TaskScheduler(ScheduledExecutorService scheduledExecutor, int shutdownAwaitSecs) {
        this(scheduledExecutor);
        this.shutdownAwaitSecs = shutdownAwaitSecs;
    }

    public boolean hasTaskAssigned() {
        return this.taskFutureExecution != null && this.task != null;
    }

    public void assignTaskForOneExecution(Task task, long delayMS) {
        this.assignTask(task, delayMS, SINGLE_EXEC_TASK_INTERVAL);
        LOG.debug("Task '{}' will run in {} millis", (Object)task.getName(), (Object)delayMS);
    }

    public void assignTaskForRepeatedExecution(Task task, long delayAndIntervalMS) {
        this.assignTaskForRepeatedExecution(task, delayAndIntervalMS, delayAndIntervalMS);
    }

    public void assignTaskForRepeatedExecution(Task task, long delayMS, long intervalMS) {
        this.assignTask(task, delayMS, intervalMS);
        LOG.debug("Task '{}' will run periodically with interval={} millis, first execution delay={} millis", task.getName(), intervalMS, delayMS);
    }

    public synchronized void cancelTask() {
        this.cancelTaskInternal(true);
    }

    public synchronized void stop() {
        this.stopTaskInternal(false);
    }

    public synchronized void stopNow() {
        this.stopTaskInternal(true);
    }

    private void stopTaskInternal(boolean mayInterruptIfRunning) {
        this.isStopping = true;
        this.cancelTaskInternal(mayInterruptIfRunning);
        this.shutdown();
        LOG.debug("Schedular was stopped");
    }

    private void cancelTaskInternal(boolean mayInterruptIfRunning) {
        if (this.taskFutureExecution != null) {
            this.taskFutureExecution.cancel(mayInterruptIfRunning);
            LOG.debug("Task '{}' was cancelled (interrupt flag={})", (Object)this.task.getName(), (Object)mayInterruptIfRunning);
            this.clearTask();
        }
    }

    private synchronized void assignTask(Task task, long delayMS, long intervalMS) {
        this.scheduleTask(task, delayMS, intervalMS);
    }

    private void scheduleTask(final Task task, final long delayMS, final long intervalMS) {
        if (this.isStopping) {
            return;
        }
        this.task = task;
        this.taskFutureExecution = this.scheduledExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    LogFactory.getLogManager().setThreadContext();
                    if (TaskScheduler.this.isStopping) {
                        return;
                    }
                    task.run();
                }
                catch (Throwable e) {
                    LOG.error("Exception occured on task execution:", e);
                }
                if (intervalMS > 0L) {
                    TaskScheduler.this.tryScheduleNextIteration(task, delayMS, intervalMS);
                } else {
                    TaskScheduler.this.clearTask();
                }
            }
        }, delayMS, TimeUnit.MILLISECONDS);
    }

    private void tryScheduleNextIteration(Task task, long delayMS, long intervalMS) {
        if (this.hasTaskAssigned()) {
            this.scheduleTask(task, intervalMS, intervalMS);
        }
    }

    private void shutdown() {
        try {
            LogFactory.getLogManager().setThreadContext();
            this.scheduledExecutor.shutdown();
            this.scheduledExecutor.awaitTermination(this.shutdownAwaitSecs, TimeUnit.SECONDS);
            LOG.debug("Shutdown done");
        }
        catch (InterruptedException e) {
            new RuntimeException(e);
        }
    }

    private void clearTask() {
        this.taskFutureExecution = null;
        this.task = null;
    }

    private static ScheduledExecutorService createScheduledExecutorThread(final String threadPoolName) {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread2 = Executors.defaultThreadFactory().newThread(runnable);
                thread2.setName(threadPoolName);
                thread2.setDaemon(true);
                return thread2;
            }
        });
        return scheduledExecutorService;
    }

    @Generated
    public void setShutdownAwaitSecs(int shutdownAwaitSecs) {
        this.shutdownAwaitSecs = shutdownAwaitSecs;
    }

    @Generated
    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    @Generated
    public boolean isStopping() {
        return this.isStopping;
    }

    public static interface Task
    extends Runnable {
        public String getName();
    }
}

