/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils.threads;

import io.sealights.onpremise.agents.infra.utils.threads.RecurrentTimer;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public final class RecurrentTimerFactory {
    public static RecurrentTimer createRecurrentTimer(final String timerName, int interval, TimeUnit timeUnit, final Runnable timerFunction) {
        return new RecurrentTimer(interval, timeUnit){

            @Override
            public String getName() {
                return timerName;
            }

            @Override
            public void run() {
                timerFunction.run();
            }
        };
    }

    public static RecurrentTimer createRecurrentTimer(String timerName, int intervalMs, Runnable timerFunction) {
        return RecurrentTimerFactory.createRecurrentTimer(timerName, intervalMs, TimeUnit.MILLISECONDS, timerFunction);
    }

    public static RecurrentTimer createRecurrentTimer(Class<?> clazz, int interval, TimeUnit timeUnit, Runnable timerFunction) {
        return RecurrentTimerFactory.createRecurrentTimer(clazz.getSimpleName() + "Timer", interval, timeUnit, timerFunction);
    }

    public static RecurrentTimer createRecurrentTimer(Class<?> clazz, int intervalMs, Runnable timerFunction) {
        return RecurrentTimerFactory.createRecurrentTimer(clazz, intervalMs, TimeUnit.MILLISECONDS, timerFunction);
    }

    @Generated
    private RecurrentTimerFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

