/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils.threads;

import io.sealights.onpremise.agents.infra.interfaces.Cancelable;
import io.sealights.onpremise.agents.infra.interfaces.Reloadable;
import io.sealights.onpremise.agents.infra.interfaces.Startable;
import io.sealights.onpremise.agents.infra.interfaces.Stoppable;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.threads.TaskScheduler;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class RecurrentTimer
implements TaskScheduler.Task,
Startable,
Stoppable,
Cancelable,
Reloadable {
    private static Logger LOG = LogFactory.getLogger(RecurrentTimer.class);
    private TaskScheduler schedular;
    private boolean isStarted;
    private long intervalMillis;

    public RecurrentTimer(int intervalSec) {
        this(intervalSec, TimeUnit.SECONDS);
    }

    public RecurrentTimer(int interval, TimeUnit units) {
        this.intervalMillis = TimeUnit.MILLISECONDS.convert(interval, units);
        if (this.intervalMillis < 1L) {
            throw new IllegalArgumentException("minimal timeunit - MILLISECONDS");
        }
        this.schedular = new TaskScheduler(this.getName());
    }

    @Override
    public synchronized void start() {
        if (this.schedular.isStopping()) {
            LOG.warn("Timer {} could not be started after stop", (Object)this.getName());
            return;
        }
        if (!this.isStarted) {
            this.isStarted = true;
            this.schedular.assignTaskForRepeatedExecution(this, this.getIntervalMillis());
            LOG.info("Started timer '{}' with intervalMillis {}", (Object)this.getName(), (Object)this.intervalMillis);
        } else {
            LOG.warn("Timer {} already started", (Object)this.getName());
        }
    }

    @Override
    public synchronized void stop() {
        this.isStarted = false;
        this.schedular.stop();
    }

    @Override
    public synchronized void cancel() {
        this.isStarted = false;
        this.schedular.cancelTask();
    }

    @Override
    public synchronized void reload() {
        this.cancel();
        this.start();
    }

    public synchronized void updateIntervalAndReload(int interval, TimeUnit timeUnit) {
        this.setIntervalMillis(timeUnit.toMillis(interval));
        this.reload();
    }

    public synchronized void updateIntervalMsAndReload(int intervalMs) {
        this.updateIntervalAndReload(intervalMs, TimeUnit.MILLISECONDS);
    }

    @Generated
    public TaskScheduler getSchedular() {
        return this.schedular;
    }

    @Generated
    public void setSchedular(TaskScheduler schedular) {
        this.schedular = schedular;
    }

    @Generated
    public boolean isStarted() {
        return this.isStarted;
    }

    @Generated
    public long getIntervalMillis() {
        return this.intervalMillis;
    }

    @Generated
    public void setIntervalMillis(long intervalMillis) {
        this.intervalMillis = intervalMillis;
    }
}

