/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils;

import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import io.sealights.onpremise.agents.infra.logging.Printer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import lombok.Generated;

public final class ToStringFormatter {
    public static final String MAX_PRINTED_ENTRIES = "... reached max printed entries, truncated ...";
    public static final String OUT_OF_MEMORY_ERROR = "Failed to convert toString due to out of memory, error: ";
    public static final String EMPTY = "empty";
    private static final String CNT_LIST_ENTRY_FROMAT = "[%3s] %s";
    private static final String CNT_KEY_ENTRY_FROMAT = "[%3s] %s: %s";

    public static <T> String toString(Collection<T> collection) {
        return ToStringFormatter.toString(collection, 1, collection != null ? collection.size() : 0);
    }

    public static <T> String toString(Collection<T> collection, int printMaxEntries) {
        return ToStringFormatter.toString(collection, 1, printMaxEntries);
    }

    public static String toString(Properties props) {
        StringBuilder buf = new StringBuilder();
        if (props.isEmpty()) {
            buf.append(EMPTY);
        } else {
            buf.append("\n");
            int ctr = 1;
            Set<String> propNames = props.stringPropertyNames();
            for (String key : propNames) {
                buf.append(String.format(CNT_KEY_ENTRY_FROMAT, ctr++, key, props.getProperty(key)));
                if (ctr > props.size()) continue;
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    public static <K, V> String toString(final Map<K, V> map2) {
        return ToStringFormatter.safeToString(new ToStringMethod(){

            @Override
            public String execute() {
                StringBuilder buf = new StringBuilder();
                if (map2.isEmpty()) {
                    buf.append(ToStringFormatter.EMPTY);
                } else {
                    buf.append("\n");
                    int ctr = 1;
                    for (Object key : map2.keySet()) {
                        buf.append(String.format(ToStringFormatter.CNT_KEY_ENTRY_FROMAT, ctr++, key, map2.get(key)));
                        if (ctr > map2.size()) continue;
                        buf.append("\n");
                    }
                }
                return buf.toString();
            }
        });
    }

    public static <T> String toStringAsJson(final Collection<T> collection, final int firstCtr) {
        return ToStringFormatter.safeToString(new ToStringMethod(){

            @Override
            public String execute() {
                return ToStringFormatter.toString(ToStringFormatter.toJsonArray((List)collection), firstCtr, collection.size());
            }
        });
    }

    private static <T> List<String> toJsonArray(List<T> objectsArray) {
        ArrayList<String> jsonArray = new ArrayList<String>();
        for (T item : objectsArray) {
            try {
                jsonArray.add(JsonObjectMapper.toJson(item));
            }
            catch (Exception e) {
                jsonArray.add(item.toString());
            }
        }
        return jsonArray;
    }

    private static <T> String toString(final Collection<T> collection, final int shiftedFirstCtr, final int printMaxEntries) {
        return ToStringFormatter.safeToString(new ToStringMethod(){

            @Override
            public String execute() {
                StringBuilder buf = new StringBuilder();
                if (collection == null || collection.isEmpty()) {
                    buf.append(ToStringFormatter.EMPTY);
                } else {
                    buf.append("\n");
                    int ctr = shiftedFirstCtr;
                    for (Object e : collection) {
                        if (ctr >= printMaxEntries + shiftedFirstCtr) {
                            buf.append(ToStringFormatter.MAX_PRINTED_ENTRIES);
                            break;
                        }
                        buf.append(String.format(ToStringFormatter.CNT_LIST_ENTRY_FROMAT, ctr++, e));
                        if (ctr >= collection.size() + shiftedFirstCtr) continue;
                        buf.append("\n");
                    }
                }
                return buf.toString();
            }
        });
    }

    public static <T> String toString(final Printer<T> printer, final T value) {
        return ToStringFormatter.safeToString(new ToStringMethod(){

            @Override
            public String execute() {
                if (printer != null) {
                    return printer.toString(value);
                }
                return "";
            }
        });
    }

    private static String safeToString(ToStringMethod method) {
        try {
            return method.execute();
        }
        catch (OutOfMemoryError e) {
            return OUT_OF_MEMORY_ERROR + e.toString();
        }
    }

    @Generated
    private ToStringFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static interface ToStringMethod {
        public String execute();
    }
}

