/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class StreamUtils {
    public static InputStream toInputStream(String str) {
        if (str == null) {
            return new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8));
        }
        return new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
    }

    public static ByteArrayInputStream toByteArrayInputStream(InputStream stream) throws IOException {
        int bytesRead;
        byte[] buff = new byte[8000];
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        while ((bytesRead = stream.read(buff)) != -1) {
            bao.write(buff, 0, bytesRead);
        }
        byte[] data2 = bao.toByteArray();
        return new ByteArrayInputStream(data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInputStreamToFile(InputStream inputStream, File targetFile) {
        FileOutputStream outputStream = null;
        try {
            int len;
            outputStream = new FileOutputStream(targetFile);
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > 0) {
                ((OutputStream)outputStream).write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.closeSafe(outputStream);
                StreamUtils.closeSafe(inputStream);
                throw throwable;
            }
            StreamUtils.closeSafe(outputStream);
            StreamUtils.closeSafe(inputStream);
        }
        StreamUtils.closeSafe(outputStream);
        StreamUtils.closeSafe(inputStream);
    }

    private static void closeSafe(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

