/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils;

import io.sealights.onpremise.agents.infra.env.OsDetector;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;

public class PathUtils {
    public static String join(String ... pathItems) {
        return PathUtils.join(Arrays.asList(pathItems));
    }

    public static String join(List<String> pathItems) {
        StringBuilder sb = new StringBuilder();
        for (String item : pathItems) {
            sb.append(item);
            sb.append(File.separator);
        }
        String result = sb.toString();
        int indexOfLastSeparator = result.lastIndexOf(File.separator);
        if (indexOfLastSeparator == result.length() - 1) {
            result = result.substring(0, indexOfLastSeparator);
        }
        return result;
    }

    public static String containingDir(String path) throws IOException {
        String canonicalPath = new File(path).getCanonicalPath();
        return canonicalPath.substring(0, canonicalPath.lastIndexOf(File.separator));
    }

    public static String relativePath(String target, String relativeTo) throws IOException {
        String canonicalTargetPath = new File(target).getCanonicalPath();
        String canonicalReferencePath = new File(relativeTo).getCanonicalPath();
        return Paths.get(canonicalReferencePath, new String[0]).relativize(Paths.get(canonicalTargetPath, new String[0])).toString();
    }

    public static String toSystemSeparator(String path) {
        return PathUtils.toSystemSeparator(path, "\\");
    }

    public static String toSystemSeparator(String path, String currentSeparator) {
        if (path == null || path.length() == 0) {
            return path;
        }
        if (path.indexOf(File.separator) < 0) {
            path = path.replace(currentSeparator, File.separator);
        }
        return path;
    }

    public static String toUnixSeparator(String path) {
        return path.replace("\\\\", "/").replace("\\", "/");
    }

    public static String toWindowsPathWithUnixSeparator(String path) {
        String resolvedPath = PathUtils.toUnixSeparator(path);
        if (OsDetector.isWindows() && resolvedPath.startsWith("/")) {
            resolvedPath = resolvedPath.substring(1);
        }
        return resolvedPath;
    }
}

