/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils;

import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class OutputRedirector {
    private static final boolean AUTO_FLUSH = true;

    public static void redirectIfNeeded() {
        String filename = System.getProperty("sl.redirectStreamsTo");
        if (!StringUtils.isNullOrEmpty(filename)) {
            OutputRedirector.redirectToFile(filename);
        }
    }

    public static void redirectToFile(String filename) {
        if (StringUtils.isNullOrEmpty(filename)) {
            throw new IllegalArgumentException("'filename' cannot be null or empty string.");
        }
        try {
            FileAndFolderUtils.verifyFolderExists(new File(filename));
            System.setOut(OutputRedirector.createFileStream(filename + ".out"));
            System.setErr(OutputRedirector.createFileStream(filename + ".err"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed redirecting output and error streams. Error:", e);
        }
    }

    private static PrintStream createFileStream(String a) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(a);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintStream stream = new PrintStream(bos, true);
        return stream;
    }
}

