/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

public class FilesCollector {
    public static final Comparator<File> FILES_BEFORE_DIRS_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File left, File right) {
            if (left.isFile() && right.isDirectory()) {
                return -1;
            }
            if (left.isDirectory() && right.isFile()) {
                return 1;
            }
            return left.compareTo(right);
        }
    };
    private final Comparator<File> fileComparator;
    private String rootFolderName;
    private FileNameFilter filter;
    List<File> collected = new ArrayList<File>();
    private static Logger LOG = LogFactory.getLogger(FilesCollector.class);

    public FilesCollector() {
        this.fileComparator = null;
    }

    public FilesCollector(Comparator<File> fileComparator) {
        this.fileComparator = fileComparator;
    }

    public List<File> collectByExactMatchEnding(String rootFolderName, String matchValue, boolean recursive) {
        this.rootFolderName = rootFolderName;
        this.filter = new ExactMatchFilter(matchValue);
        return this.collect(recursive);
    }

    public List<File> collectByIgnoreCaseMatchEnding(String rootFolderName, String matchValue, boolean recursive) {
        this.rootFolderName = rootFolderName;
        this.filter = new IgnoreCaseMatchFilter(matchValue);
        return this.collect(recursive);
    }

    public List<File> collect(String rootFolderName, boolean recursive, FileNameFilter filter) {
        this.rootFolderName = rootFolderName;
        this.filter = filter;
        return this.collect(recursive);
    }

    private List<File> collect(boolean recursive) {
        if (this.filter == null) {
            LOG.info("No filter was provided, cannot collect file names");
        } else {
            this.applyFilter(recursive);
        }
        return this.collected;
    }

    private void applyFilter(boolean recursive) {
        if (StringUtils.isNullOrEmpty(this.rootFolderName)) {
            LOG.info("The folder is not defined, cannot collect file names");
            return;
        }
        File rootFolder = new File(this.rootFolderName);
        if (!rootFolder.exists()) {
            LOG.info("Folder '{}' does not exist, cannot collect file names", (Object)this.rootFolderName);
            return;
        }
        if (rootFolder.isFile()) {
            if (this.filter.matches(rootFolder)) {
                this.collected.add(rootFolder);
            }
        } else {
            this.lookInFolder(rootFolder, recursive);
        }
    }

    private void lookInFolder(File folder, boolean recursive) {
        File[] children = folder.listFiles();
        if (children == null) {
            return;
        }
        if (this.fileComparator != null) {
            Arrays.sort(children, this.fileComparator);
        }
        for (File child : children) {
            if (child.isDirectory() && recursive) {
                this.lookInFolder(child, recursive);
                continue;
            }
            if (!this.filter.matches(child)) continue;
            this.collected.add(child);
        }
    }

    public static interface FileNameFilter {
        public boolean matches(File var1);
    }

    static class IgnoreCaseMatchFilter
    implements FileNameFilter {
        private String match;

        @Override
        public boolean matches(File other) {
            return other.getName().toLowerCase().endsWith(this.match);
        }

        @Generated
        public IgnoreCaseMatchFilter(String match) {
            this.match = match;
        }
    }

    static class ExactMatchFilter
    implements FileNameFilter {
        private String exactMatch;

        @Override
        public boolean matches(File other) {
            return other.getName().endsWith(this.exactMatch);
        }

        @Generated
        public ExactMatchFilter(String exactMatch) {
            this.exactMatch = exactMatch;
        }
    }
}

