/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.types;

import java.util.Objects;
import lombok.Generated;

public class ExecutionDescriptor {
    private String executionId;
    private String buildSessionId;
    private String testStage;
    private String testGroupId;
    private Status status = Status.created;
    private Long timestamp;
    private Long timestampPendingDelete;
    private Long timestampDeleting;
    private Long timestampDelete;
    private Exception exception;

    public ExecutionDescriptor(String executionId, String buildSessionId, String testStage, Status status, String testGroupId) {
        this.executionId = executionId;
        this.buildSessionId = buildSessionId;
        this.testStage = testStage;
        this.status = status;
        this.testGroupId = testGroupId;
    }

    public boolean isStateEqual(ExecutionDescriptor other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.buildSessionId.equalsIgnoreCase(other.buildSessionId) && this.testStage.equalsIgnoreCase(other.testStage) && this.status == other.status && Objects.equals(this.testGroupId, other.testGroupId);
    }

    public boolean isEquivalent(ExecutionDescriptor other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.buildSessionId.equalsIgnoreCase(other.buildSessionId) && this.testStage.equalsIgnoreCase(other.testStage) && Objects.equals(this.testGroupId, other.testGroupId);
    }

    public boolean isPendingDelete() {
        return this.status == Status.pendingDelete;
    }

    public boolean isExpired(long currentTimestampMs, long expirationDelayMs) {
        return this.status == Status.ended && this.timestampDelete != null && currentTimestampMs - this.timestampDelete > expirationDelayMs;
    }

    public String toString() {
        return String.format("executionId=%s, buildSessionId=%s, testStage=%s, status=%s, testGroupId=%s", new Object[]{this.executionId, this.buildSessionId, this.testStage, this.status, this.testGroupId});
    }

    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Generated
    public String getBuildSessionId() {
        return this.buildSessionId;
    }

    @Generated
    public String getTestStage() {
        return this.testStage;
    }

    @Generated
    public String getTestGroupId() {
        return this.testGroupId;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Long getTimestampPendingDelete() {
        return this.timestampPendingDelete;
    }

    @Generated
    public Long getTimestampDeleting() {
        return this.timestampDeleting;
    }

    @Generated
    public Long getTimestampDelete() {
        return this.timestampDelete;
    }

    @Generated
    public Exception getException() {
        return this.exception;
    }

    @Generated
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Generated
    public void setBuildSessionId(String buildSessionId) {
        this.buildSessionId = buildSessionId;
    }

    @Generated
    public void setTestStage(String testStage) {
        this.testStage = testStage;
    }

    @Generated
    public void setTestGroupId(String testGroupId) {
        this.testGroupId = testGroupId;
    }

    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @Generated
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setTimestampPendingDelete(Long timestampPendingDelete) {
        this.timestampPendingDelete = timestampPendingDelete;
    }

    @Generated
    public void setTimestampDeleting(Long timestampDeleting) {
        this.timestampDeleting = timestampDeleting;
    }

    @Generated
    public void setTimestampDelete(Long timestampDelete) {
        this.timestampDelete = timestampDelete;
    }

    @Generated
    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionDescriptor)) {
            return false;
        }
        ExecutionDescriptor other = (ExecutionDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Long this$timestampPendingDelete = this.getTimestampPendingDelete();
        Long other$timestampPendingDelete = other.getTimestampPendingDelete();
        if (this$timestampPendingDelete == null ? other$timestampPendingDelete != null : !((Object)this$timestampPendingDelete).equals(other$timestampPendingDelete)) {
            return false;
        }
        Long this$timestampDeleting = this.getTimestampDeleting();
        Long other$timestampDeleting = other.getTimestampDeleting();
        if (this$timestampDeleting == null ? other$timestampDeleting != null : !((Object)this$timestampDeleting).equals(other$timestampDeleting)) {
            return false;
        }
        Long this$timestampDelete = this.getTimestampDelete();
        Long other$timestampDelete = other.getTimestampDelete();
        if (this$timestampDelete == null ? other$timestampDelete != null : !((Object)this$timestampDelete).equals(other$timestampDelete)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        String this$buildSessionId = this.getBuildSessionId();
        String other$buildSessionId = other.getBuildSessionId();
        if (this$buildSessionId == null ? other$buildSessionId != null : !this$buildSessionId.equals(other$buildSessionId)) {
            return false;
        }
        String this$testStage = this.getTestStage();
        String other$testStage = other.getTestStage();
        if (this$testStage == null ? other$testStage != null : !this$testStage.equals(other$testStage)) {
            return false;
        }
        String this$testGroupId = this.getTestGroupId();
        String other$testGroupId = other.getTestGroupId();
        if (this$testGroupId == null ? other$testGroupId != null : !this$testGroupId.equals(other$testGroupId)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Exception this$exception = this.getException();
        Exception other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExecutionDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Long $timestampPendingDelete = this.getTimestampPendingDelete();
        result = result * 59 + ($timestampPendingDelete == null ? 43 : ((Object)$timestampPendingDelete).hashCode());
        Long $timestampDeleting = this.getTimestampDeleting();
        result = result * 59 + ($timestampDeleting == null ? 43 : ((Object)$timestampDeleting).hashCode());
        Long $timestampDelete = this.getTimestampDelete();
        result = result * 59 + ($timestampDelete == null ? 43 : ((Object)$timestampDelete).hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        String $buildSessionId = this.getBuildSessionId();
        result = result * 59 + ($buildSessionId == null ? 43 : $buildSessionId.hashCode());
        String $testStage = this.getTestStage();
        result = result * 59 + ($testStage == null ? 43 : $testStage.hashCode());
        String $testGroupId = this.getTestGroupId();
        result = result * 59 + ($testGroupId == null ? 43 : $testGroupId.hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Exception $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }

    @Generated
    public ExecutionDescriptor() {
    }

    public static enum Status {
        created,
        pendingDelete,
        deleting,
        ended;

    }
}

