/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.token;

import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import io.sealights.onpremise.agents.infra.token.TokenTruncated;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class TokenValueFormatter {
    public static final String SYS_PROP_VALUE_PPREFIX = "\"";
    public static final String DASH = "-";
    private static final String TOKEN_ARG = "token";

    public static String truncateTokenArgValue(String tokenArgValue) {
        return TokenTruncated.truncate(tokenArgValue);
    }

    public static String truncateTokenSysProperty(String strWithTokenProperty, String optionalTokenValue) {
        if (StringUtils.isNullOrEmpty(strWithTokenProperty) || StringUtils.isNotEmpty(optionalTokenValue) && optionalTokenValue.length() <= 10) {
            return strWithTokenProperty;
        }
        String PREFIX = "sl.token=";
        int tokenBeginIndex = strWithTokenProperty.indexOf("sl.token=");
        if (tokenBeginIndex == -1) {
            return strWithTokenProperty;
        }
        boolean hasQuotes = false;
        if (strWithTokenProperty.substring(tokenBeginIndex += "sl.token=".length()).startsWith(SYS_PROP_VALUE_PPREFIX)) {
            ++tokenBeginIndex;
            hasQuotes = true;
        }
        if (optionalTokenValue != null) {
            int tokenEndIndex = Math.min(tokenBeginIndex + optionalTokenValue.length() + 1, strWithTokenProperty.length() - 1);
            return String.format("%s%s%s", strWithTokenProperty.substring(0, tokenBeginIndex), TokenTruncated.truncate(optionalTokenValue), strWithTokenProperty.substring(tokenEndIndex));
        }
        int tokenEndIndex = strWithTokenProperty.length();
        if (hasQuotes) {
            --tokenEndIndex;
        }
        optionalTokenValue = strWithTokenProperty.substring(tokenBeginIndex, tokenEndIndex);
        return String.format("%s%s%s", strWithTokenProperty.substring(0, tokenBeginIndex), TokenTruncated.truncate(optionalTokenValue), hasQuotes ? SYS_PROP_VALUE_PPREFIX : "");
    }

    public static String truncateTokenSysProperty(String strWithTokenProperty) {
        return TokenValueFormatter.truncateTokenSysProperty(strWithTokenProperty, null);
    }

    public static String toStringSysPropertiesWithToken(Map<String, ?> systemProperties) {
        StringBuilder sb = new StringBuilder("{");
        int ctr = 1;
        for (String key : systemProperties.keySet()) {
            if ("sl.token".equals(key)) {
                sb.append(String.format("%s=%s", key, TokenValueFormatter.truncateTokenArgValue((String)systemProperties.get(key))));
            } else {
                sb.append(String.format("%s=%s", key, systemProperties.get(key)));
            }
            if (ctr >= systemProperties.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String toJson(String[] jvmArgs) {
        return TokenValueFormatter.toJson(Arrays.asList(jvmArgs));
    }

    public static String toJson(List<String> jvmArgs) {
        return JsonObjectMapper.toJson(TokenValueFormatter.truncateTokenInArgs(jvmArgs));
    }

    public static List<String> truncateTokenInArgs(List<String> jvmArgs) {
        ArrayList<String> argsCopy = new ArrayList<String>();
        if (jvmArgs == null) {
            return argsCopy;
        }
        boolean prevArgWasToken = false;
        for (String s2 : jvmArgs) {
            if (prevArgWasToken) {
                s2 = TokenValueFormatter.truncateTokenArgValue(s2);
                prevArgWasToken = false;
            }
            if (s2.contains("sl.token")) {
                s2 = TokenValueFormatter.truncateTokenSysProperty(s2);
            }
            argsCopy.add(s2);
            if (!s2.equals("-token")) continue;
            prevArgWasToken = true;
        }
        return argsCopy;
    }

    @Generated
    private TokenValueFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

