/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.token;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.sealights.onpremise.agents.infra.token.TokenError;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TokenData {
    private String customerId;
    private String subject;
    private String role;
    private String server;
    List<TokenError> validationErrors = new ArrayList<TokenError>();
    public static final String AgentRole = "agent";
    public static final String TokenPrefix = "eyJhbGciOiJSUzUxMiIsInR5cCI6IkpXVCJ9.";

    public String getCustomerId() {
        String[] parts;
        if (this.customerId != null) {
            return this.customerId;
        }
        if (this.getSubject() != null && this.getSubject().contains("@") && (parts = this.getSubject().split("@")).length == 2) {
            this.customerId = parts[0];
        }
        return this.customerId;
    }

    @JsonProperty(value="x-sl-role")
    public void setRole(String role) {
        this.role = role;
    }

    @JsonProperty(value="x-sl-server")
    public void setServer(String server) {
        this.server = server;
    }

    public boolean isValid() {
        return this.validationErrors == null || this.validationErrors.isEmpty();
    }

    public void addError(TokenError error) {
        this.validationErrors.add(error);
    }

    public String toStringErrors() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.validationErrors.size(); ++i) {
            TokenError err = this.validationErrors.get(i);
            buf.append(err.toString());
            if (i >= this.validationErrors.size() - 1) continue;
            buf.append(";");
        }
        return buf.toString();
    }

    @Generated
    public TokenData() {
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public List<TokenError> getValidationErrors() {
        return this.validationErrors;
    }

    @Generated
    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public void setValidationErrors(List<TokenError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenData)) {
            return false;
        }
        TokenData other = (TokenData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$customerId = this.getCustomerId();
        String other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !this$customerId.equals(other$customerId)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        List<TokenError> this$validationErrors = this.getValidationErrors();
        List<TokenError> other$validationErrors = other.getValidationErrors();
        return !(this$validationErrors == null ? other$validationErrors != null : !((Object)this$validationErrors).equals(other$validationErrors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TokenData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : $customerId.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        List<TokenError> $validationErrors = this.getValidationErrors();
        result = result * 59 + ($validationErrors == null ? 43 : ((Object)$validationErrors).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TokenData(customerId=" + this.getCustomerId() + ", subject=" + this.getSubject() + ", role=" + this.getRole() + ", server=" + this.getServer() + ", validationErrors=" + this.getValidationErrors() + ")";
    }
}

