/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.time.sync.utils;

import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.time.sync.TimeClockServiceHandler;
import io.sealights.onpremise.agents.infra.time.sync.TimeSyncResponse;
import io.sealights.onpremise.agents.infra.time.sync.TimeSyncStatus;
import io.sealights.onpremise.agents.infra.utils.threads.TaskScheduler;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;

public class TimeClockDispatcher
implements TaskScheduler.Task {
    public static final int TIME_SYNC_INTERVAL_SEC = 10;
    private static String TIME_SYNC_COCKPIT_WARNING_MSG = "Agent is not synchronized with the TimeSync Server";
    private static final Logger LOG = LogFactory.getLogger(TimeClockDispatcher.class);
    private static final ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private static final String TIME_SYNCHRONIZER = "time-synchronizer";
    public static long CONNECTION_TIMEOUT_MS = 500L;
    private String server;
    private String proxyConfig;
    private int timerIntervalSec = 10;
    private boolean syncDone;
    private final TaskScheduler taskScheduler;
    private final AtomicBoolean isShuttingDown = new AtomicBoolean(false);
    private TimeSyncStatus timeSyncStatus;
    private static TimeClockDispatcher INSTANCE = null;
    private String agentId;
    private boolean enabled = false;
    private TimeClockServiceHandler timeClockServiceProxy;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);

    @Override
    public String getName() {
        return TIME_SYNCHRONIZER;
    }

    public TimeSyncStatus getTimeSyncStatus() {
        return this.timeSyncStatus;
    }

    public boolean isSyncDone() {
        return this.syncDone;
    }

    public void enableTimeClock(boolean enable) {
        this.stopOrStart(enable);
    }

    private void stopOrStart(boolean enable) {
        this.setEnabled(enable);
        if (enable) {
            if (!this.isRunning.get()) {
                this.start();
            }
        } else if (this.isRunning.get()) {
            this.stop();
        }
    }

    private TimeClockDispatcher(String agentId, TimeClockServiceHandler timeClockServiceProxy, TaskScheduler taskScheduler) {
        this.agentId = agentId;
        this.taskScheduler = taskScheduler;
        this.timeClockServiceProxy = timeClockServiceProxy;
    }

    public static TimeClockDispatcher getInstance(String agentId, TimeClockServiceHandler timeClockServiceProxy) {
        if (null == INSTANCE) {
            INSTANCE = new TimeClockDispatcher(agentId, timeClockServiceProxy, new TaskScheduler(TIME_SYNCHRONIZER));
        }
        return INSTANCE;
    }

    protected synchronized void doSync() {
        String TIME_CLOCK_SYNC_FMT = "Time clock sync at [%d]";
        long currTimestampMs = System.currentTimeMillis();
        LOG.info(String.format(TIME_CLOCK_SYNC_FMT + " ...", currTimestampMs));
        try {
            TimeSyncResponse response = this.timeClockServiceProxy.getTimeClockRequest(currTimestampMs);
            if (response != null) {
                LOG.debug(String.format(TIME_CLOCK_SYNC_FMT + " succeeded.", currTimestampMs));
                this.timeSyncStatus = new TimeSyncStatus(response.getYourTime(), response.getOffset(), true);
            } else {
                LOG.warn(String.format(TIME_CLOCK_SYNC_FMT + " did not succeed.", currTimestampMs));
                this.timeSyncStatus = new TimeSyncStatus(currTimestampMs, 0L, false);
            }
        }
        catch (Exception ex) {
            LOG.error(String.format(TIME_CLOCK_SYNC_FMT + " did not succeed; Error.:", currTimestampMs), ex);
            if (this.timeSyncStatus == null) {
                this.timeSyncStatus = new TimeSyncStatus(currTimestampMs, 0L, false);
            }
            this.timeSyncStatus.setSuccess(false);
        }
        this.syncDone = true;
    }

    public void rescheduleRun() {
        this.stop();
        this.stopOrStart(this.isEnabled());
    }

    protected void scheduleRun(int delayMS, int interval) {
        this.taskScheduler.assignTaskForRepeatedExecution(this, delayMS, interval);
    }

    @Override
    public void run() {
        this.doSync();
    }

    public void start() {
        if (!this.isShuttingDown.get() && !this.taskScheduler.hasTaskAssigned()) {
            int timerIntervalMs = this.getTimerIntervalSec() * 1000;
            this.scheduleRun(0, timerIntervalMs);
            LOG.info("Time Clock synchronization is scheduled with interval " + timerIntervalMs + " [ms]");
        }
    }

    public void stop() {
        if (this.isRunning.get()) {
            this.taskScheduler.stop();
            this.isShuttingDown.set(true);
            this.isRunning.set(false);
        }
    }

    public long getOffsetMs() {
        long offset = 0L;
        if (null == this.timeSyncStatus) {
            if (this.isEnabled()) {
                LOG.error("timeSyncStatus=='null'");
            }
            return offset;
        }
        if (!this.timeSyncStatus.isSuccess()) {
            if (this.isEnabled()) {
                LOG.error("timeSyncStatus.isSuccess=='false'");
            }
            return offset;
        }
        LOG.debug("Offset: " + this.timeSyncStatus.getLastOffset());
        return this.timeSyncStatus.getLastOffset();
    }

    public long getTimeClock() {
        long currentTime = System.currentTimeMillis();
        if (null == this.timeSyncStatus) {
            if (this.isEnabled()) {
                LOG.error("timeSyncStatus=='null'");
            }
            return currentTime;
        }
        if (!this.timeSyncStatus.isSuccess()) {
            if (this.isEnabled()) {
                LOG.error("timeSyncStatus.isSuccess=='false'");
            }
            return currentTime;
        }
        LOG.info("Current time: " + currentTime + " Offset: " + this.timeSyncStatus.getLastOffset());
        return currentTime + this.timeSyncStatus.getLastOffset();
    }

    public static String createCockpitMessage(String reason) {
        return TIME_SYNC_COCKPIT_WARNING_MSG + ", reason: " + reason;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public String getProxyConfig() {
        return this.proxyConfig;
    }

    @Generated
    public int getTimerIntervalSec() {
        return this.timerIntervalSec;
    }

    @Generated
    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    @Generated
    public AtomicBoolean getIsShuttingDown() {
        return this.isShuttingDown;
    }

    @Generated
    public String getAgentId() {
        return this.agentId;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public TimeClockServiceHandler getTimeClockServiceProxy() {
        return this.timeClockServiceProxy;
    }

    @Generated
    public AtomicBoolean getIsRunning() {
        return this.isRunning;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setProxyConfig(String proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    @Generated
    public void setTimerIntervalSec(int timerIntervalSec) {
        this.timerIntervalSec = timerIntervalSec;
    }

    @Generated
    public void setSyncDone(boolean syncDone) {
        this.syncDone = syncDone;
    }

    @Generated
    public void setTimeSyncStatus(TimeSyncStatus timeSyncStatus) {
        this.timeSyncStatus = timeSyncStatus;
    }

    @Generated
    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setTimeClockServiceProxy(TimeClockServiceHandler timeClockServiceProxy) {
        this.timeClockServiceProxy = timeClockServiceProxy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeClockDispatcher)) {
            return false;
        }
        TimeClockDispatcher other = (TimeClockDispatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimerIntervalSec() != other.getTimerIntervalSec()) {
            return false;
        }
        if (this.isSyncDone() != other.isSyncDone()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$proxyConfig = this.getProxyConfig();
        String other$proxyConfig = other.getProxyConfig();
        if (this$proxyConfig == null ? other$proxyConfig != null : !this$proxyConfig.equals(other$proxyConfig)) {
            return false;
        }
        TaskScheduler this$taskScheduler = this.getTaskScheduler();
        TaskScheduler other$taskScheduler = other.getTaskScheduler();
        if (this$taskScheduler == null ? other$taskScheduler != null : !this$taskScheduler.equals(other$taskScheduler)) {
            return false;
        }
        AtomicBoolean this$isShuttingDown = this.getIsShuttingDown();
        AtomicBoolean other$isShuttingDown = other.getIsShuttingDown();
        if (this$isShuttingDown == null ? other$isShuttingDown != null : !this$isShuttingDown.equals(other$isShuttingDown)) {
            return false;
        }
        TimeSyncStatus this$timeSyncStatus = this.getTimeSyncStatus();
        TimeSyncStatus other$timeSyncStatus = other.getTimeSyncStatus();
        if (this$timeSyncStatus == null ? other$timeSyncStatus != null : !((Object)this$timeSyncStatus).equals(other$timeSyncStatus)) {
            return false;
        }
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId)) {
            return false;
        }
        TimeClockServiceHandler this$timeClockServiceProxy = this.getTimeClockServiceProxy();
        TimeClockServiceHandler other$timeClockServiceProxy = other.getTimeClockServiceProxy();
        if (this$timeClockServiceProxy == null ? other$timeClockServiceProxy != null : !((Object)this$timeClockServiceProxy).equals(other$timeClockServiceProxy)) {
            return false;
        }
        AtomicBoolean this$isRunning = this.getIsRunning();
        AtomicBoolean other$isRunning = other.getIsRunning();
        return !(this$isRunning == null ? other$isRunning != null : !this$isRunning.equals(other$isRunning));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeClockDispatcher;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTimerIntervalSec();
        result = result * 59 + (this.isSyncDone() ? 79 : 97);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $proxyConfig = this.getProxyConfig();
        result = result * 59 + ($proxyConfig == null ? 43 : $proxyConfig.hashCode());
        TaskScheduler $taskScheduler = this.getTaskScheduler();
        result = result * 59 + ($taskScheduler == null ? 43 : $taskScheduler.hashCode());
        AtomicBoolean $isShuttingDown = this.getIsShuttingDown();
        result = result * 59 + ($isShuttingDown == null ? 43 : $isShuttingDown.hashCode());
        TimeSyncStatus $timeSyncStatus = this.getTimeSyncStatus();
        result = result * 59 + ($timeSyncStatus == null ? 43 : ((Object)$timeSyncStatus).hashCode());
        String $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        TimeClockServiceHandler $timeClockServiceProxy = this.getTimeClockServiceProxy();
        result = result * 59 + ($timeClockServiceProxy == null ? 43 : ((Object)$timeClockServiceProxy).hashCode());
        AtomicBoolean $isRunning = this.getIsRunning();
        result = result * 59 + ($isRunning == null ? 43 : $isRunning.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimeClockDispatcher(server=" + this.getServer() + ", proxyConfig=" + this.getProxyConfig() + ", timerIntervalSec=" + this.getTimerIntervalSec() + ", syncDone=" + this.isSyncDone() + ", taskScheduler=" + this.getTaskScheduler() + ", isShuttingDown=" + this.getIsShuttingDown() + ", timeSyncStatus=" + this.getTimeSyncStatus() + ", agentId=" + this.getAgentId() + ", enabled=" + this.isEnabled() + ", timeClockServiceProxy=" + this.getTimeClockServiceProxy() + ", isRunning=" + this.getIsRunning() + ")";
    }
}

