/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.time.sync.http.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.time.sync.TimeSyncResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;

public class TimeSyncSimpleHttpClient {
    private String baseUrl;
    private ProxyInfo proxyInfo;
    private long connectionTimeoutMs;
    private static final ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private static final Logger LOG = LogFactory.getLogger(TimeSyncSimpleHttpClient.class);

    public TimeSyncSimpleHttpClient(String baseUrl, ProxyInfo proxyInfo, long connectionTimeoutMs) {
        this.baseUrl = baseUrl;
        this.proxyInfo = proxyInfo;
        this.connectionTimeoutMs = connectionTimeoutMs;
        LOG.debug("Created {}", (Object)this.getClass().getSimpleName());
    }

    private ClassicHttpResponse retrieveHttpGetResponse(HttpGet get) throws IOException {
        if (this.proxyInfo != null) {
            HttpHost proxy = new HttpHost(this.proxyInfo.getHost(), this.proxyInfo.getPort());
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(this.proxyInfo.getHost(), this.proxyInfo.getPort()), new UsernamePasswordCredentials(this.proxyInfo.getUser(), this.proxyInfo.getPassword().toCharArray()));
            HttpClientContext context = HttpClientContext.create();
            context.setCredentialsProvider(credsProvider);
            context.setAuthCache(authCache);
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider(credsProvider).setRoutePlanner(routePlanner).build();
            return (ClassicHttpResponse)httpClient.execute((ClassicHttpRequest)get, context);
        }
        return HttpClients.createDefault().execute(get);
    }

    public TimeSyncResponse sendGetTimeSyncRequest(long currentTime) throws URISyntaxException {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("time", "" + currentTime));
        HttpGet get = new HttpGet(this.baseUrl);
        get.setUri(new URIBuilder(get.getUri()).addParameters(nameValuePairs).build());
        Timeout timeoutMs = Timeout.ofMilliseconds(this.connectionTimeoutMs);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(timeoutMs).setConnectTimeout(timeoutMs).build();
        get.setConfig(requestConfig);
        try {
            ClassicHttpResponse response = this.retrieveHttpGetResponse(get);
            int httpCode = response.getCode();
            LOG.debug("" + httpCode);
            HttpEntity entity = response.getEntity();
            String responseString = EntityUtils.toString(entity, "UTF-8");
            LOG.debug(responseString);
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.readValue(responseString, TimeSyncResponse.class);
            }
            catch (JsonProcessingException je) {
                je.printStackTrace();
                return null;
            }
        }
        catch (IOException | ParseException prioe) {
            prioe.printStackTrace();
            return null;
        }
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Generated
    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    @Generated
    public void setProxyInfo(ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo;
    }

    @Generated
    public long getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    @Generated
    public void setConnectionTimeoutMs(long connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }
}

