/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.time.sync;

import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.api.SLServiceProxy;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.time.sync.TimeSyncResponse;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;

public class TimeClockServiceHandler
extends SLServiceProxy {
    private static final Logger LOG = LogFactory.getLogger(TimeClockServiceHandler.class);
    private static final ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    public static final String ROOT = "/clock/sync";
    private boolean enabled = false;
    private int timeSyncIntervalSec = 10;

    public TimeClockServiceHandler(String token, String server, String proxyConfig) {
        super(token, server, proxyConfig);
    }

    @Override
    public String getTag() {
        return "TCS";
    }

    public TimeSyncResponse getTimeClockRequest(long currentTime) {
        this.logDbgMsg(String.format("requesting time clock: [%d]", currentTime));
        String requestUrl = null;
        try {
            ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
            nameValuePairs.add(new BasicNameValuePair("time", "" + currentTime));
            requestUrl = new URIBuilder(this.getServer().replace("/api", "") + ROOT).addParameters(nameValuePairs).build().toString();
            SLHttpResult<TimeSyncResponse> slResult = this.getHttpClient().sendGetRequest(new SLHttpRequest<TimeSyncResponse>(this.getTag(), requestUrl, TimeSyncResponse.class));
            if (slResult.isStatusCodeOk()) {
                return this.logOkResult(slResult, requestUrl);
            }
            this.logErrorResult(requestUrl, null);
            return null;
        }
        catch (Exception e) {
            this.logErrorResult(requestUrl, e);
            return null;
        }
    }

    protected TimeSyncResponse logOkResult(SLHttpResult<TimeSyncResponse> slResult, String requestUrl) {
        TimeSyncResponse timeSyncResponse = slResult.getResponseObject();
        String msg = String.format("Successful time clock sync against '%s', clock time: %s, offset: %s", requestUrl, timeSyncResponse.getCurrentTime(), timeSyncResponse.getOffset());
        this.logDbgMsg(msg);
        return timeSyncResponse;
    }

    protected void logErrorResult(String requestUrl, Exception e) {
        String msg = String.format("failed to sent '%s'", requestUrl);
        if (e != null) {
            this.logErrorMsg(msg, e);
        } else {
            this.logErrorMsg(msg);
        }
    }

    protected void logDbgMsg(String msg) {
        CONSOLE_LOG.debug(msg);
        LOG.debug(msg);
    }

    protected void logInfoMsg(String msg) {
        CONSOLE_LOG.info(msg);
        LOG.info(msg);
    }

    protected void logErrorMsg(String msg) {
        CONSOLE_LOG.error(msg);
        LOG.error(msg);
    }

    protected void logErrorMsg(String msg, Exception e) {
        CONSOLE_LOG.error(msg, e);
        LOG.error(msg, e);
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public int getTimeSyncIntervalSec() {
        return this.timeSyncIntervalSec;
    }

    @Generated
    public void setTimeSyncIntervalSec(int timeSyncIntervalSec) {
        this.timeSyncIntervalSec = timeSyncIntervalSec;
    }
}

