/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.serviceproxy.version;

import io.sealights.onpremise.agents.infra.configuration.UpgradeConfiguration;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClient;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.api.SLServiceProxy;
import io.sealights.onpremise.agents.infra.serviceproxy.version.FileDownloadTask;
import io.sealights.onpremise.agents.infra.serviceproxy.version.GetVersionResponse;
import io.sealights.onpremise.agents.infra.serviceproxy.version.VersionServiceProxy;
import io.sealights.onpremise.agents.infra.urlbuilder.UrlBuilder;

public class VersionServiceProxyHandler
extends SLServiceProxy
implements VersionServiceProxy {
    private static final String RECOMMENDED = "recommended";
    private UpgradeConfiguration upgradeConfiguration;
    private FileDownloadTask downloadAgentTask;

    public VersionServiceProxyHandler(UpgradeConfiguration upgradeConfiguration) {
        super(upgradeConfiguration.getToken(), upgradeConfiguration.getServer(), upgradeConfiguration.getProxy());
        this.upgradeConfiguration = upgradeConfiguration;
        this.downloadAgentTask = new FileDownloadTask(this);
    }

    @Override
    public GetVersionResponse getRecommendedVersion(String componentName) {
        String serverUrl = this.createUrlToGetRecommendedVersion(componentName);
        SLHttpResult<GetVersionResponse> upgradeResponse = this.getHttpClient().sendGetRequest(new SLHttpRequest<GetVersionResponse>(this.getTag(), serverUrl, GetVersionResponse.class));
        return upgradeResponse.getResponseObject();
    }

    private String createUrlToGetRecommendedVersion(String componentName) {
        return new UrlBuilder().withHost(this.upgradeConfiguration.getServer()).withPath("v2", "agents", componentName, RECOMMENDED).withQueryParam("customerId", this.upgradeConfiguration.getCustomerId()).withQueryParam("appName", this.upgradeConfiguration.getAppName()).withQueryParam("branch", this.upgradeConfiguration.getBranchName()).withQueryParam("envName", this.upgradeConfiguration.getEnvironmentName()).build();
    }

    @Override
    public boolean downloadAgent(String urlToAgent, String destFile) {
        this.downloadAgentTask.setInputArgs(new FileDownloadTask.FileDownloadInput(urlToAgent, destFile));
        return this.downloadAgentTask.executeDownload();
    }

    @Override
    public SLHttpClient getHttpClient() {
        return super.getHttpClient();
    }

    @Override
    public String getTag() {
        return "RVS";
    }
}

