/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.serviceproxy.labids;

import io.sealights.onpremise.agents.infra.env.AgentId;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.api.SLServiceProxy;
import io.sealights.onpremise.agents.infra.serviceproxy.labids.LabIdsServiceProxy;
import io.sealights.onpremise.agents.infra.types.BuildSessionData;
import io.sealights.onpremise.agents.infra.urlbuilder.UrlBuilder;

public class LabIdsServiceProxyHandler
extends SLServiceProxy
implements LabIdsServiceProxy {
    public static final String BUILDSESSIONS = "build-sessions";
    public static final String LAB_IDS = "lab-ids";
    public static final String ACTIVE = "active";
    public static final String AGENT_ID = "agentId";
    private static final String FAILED_GET_DATA_FMT = "Failed to get build session for labid '%s'";

    public LabIdsServiceProxyHandler(String token, String server, String proxyConfig) {
        super(token, server, proxyConfig);
    }

    @Override
    public BuildSessionData getBuildSessionData(String labId) {
        try {
            String url = new UrlBuilder().withHost(this.getServer()).withPath("v1", LAB_IDS, labId, BUILDSESSIONS, ACTIVE).withQueryParam(AGENT_ID, AgentId.getAgentId()).build();
            SLHttpResult<BuildSessionData> result = this.doGet(url);
            return result.getResponseObject();
        }
        catch (Exception e) {
            String errorMsg = String.format(FAILED_GET_DATA_FMT, labId);
            this.logError(errorMsg, e);
            return null;
        }
    }

    @Override
    public String getTag() {
        return "LABS";
    }

    private SLHttpResult<BuildSessionData> doGet(String resolvedUrl) {
        return this.getHttpClient().sendGetRetry(new SLHttpRequest<BuildSessionData>(this.getTag(), resolvedUrl, BuildSessionData.class));
    }
}

