/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.serviceproxy.executionstate;

import io.sealights.onpremise.agentevents.engine.AgentEventsController;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.ExecutionIdEvents;
import io.sealights.onpremise.agents.infra.env.AgentId;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClientFactory;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.api.SLServiceProxy;
import io.sealights.onpremise.agents.infra.logging.ExceptionStackTrace;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.serviceproxy.executionstate.ExecutionStateProxy;
import io.sealights.onpremise.agents.infra.serviceproxy.executionstate.LabIdResolver;
import io.sealights.onpremise.agents.infra.serviceproxy.executionstate.StartExecutionRequest;
import io.sealights.onpremise.agents.infra.types.BuildSessionData;
import io.sealights.onpremise.agents.infra.types.ExecutionData;
import io.sealights.onpremise.agents.infra.types.ExecutionResolution;
import io.sealights.onpremise.agents.infra.urlbuilder.UrlBuilder;
import org.slf4j.Logger;

public class ExecutionStateProxyHandler
extends SLServiceProxy
implements ExecutionStateProxy {
    private static Logger LOG = LogFactory.getLogger(ExecutionStateProxyHandler.class);
    private static final String[] URL_PATHS_V3 = new String[]{"v3", "testExecution"};
    protected static final String ANONYMOUS_EXECUTION = "anonymous execution";
    private static final String FAILED_CREATE_EXECUTION_FMT = "Failed to create execution '%s': %s";
    private static final String FAILED_DELETE_EXECUTION_FMT = "Failed to delete execution '%s': %s";
    private AgentEventsController eventsController;

    public ExecutionStateProxyHandler(String token, String server, String proxyConfig) {
        this(token, server, proxyConfig, null);
    }

    public ExecutionStateProxyHandler(String token, String server, String proxyConfig, AgentEventsController eventsController) {
        super(token, server, proxyConfig);
        this.setHttpClient(SLHttpClientFactory.getSLApacheHttpClient(token, this.getProxyInfo()));
        this.eventsController = eventsController;
    }

    @Override
    public boolean startAnonymousExecution(String testStage, BuildSessionData buildSessionData, String optionalLabId, String testGroupId) {
        String labId = LabIdResolver.resolve(buildSessionData, optionalLabId);
        return this.sendStartExecutionRequest(Routes.buildStartExecutionUrl(this.getServer()), new StartExecutionRequest(buildSessionData, labId, testStage, AgentId.getAgentId(), testGroupId), null);
    }

    @Override
    public boolean startColoredExecution(String executionId, String testStage, BuildSessionData buildSessionData, String optionalLabId, String testGroupId) {
        String labId = LabIdResolver.resolve(buildSessionData, optionalLabId);
        return this.sendStartExecutionRequest(Routes.buildStartExecutionUrl(this.getServer()), new StartExecutionRequest(executionId, buildSessionData, labId, testStage, AgentId.getAgentId(), testGroupId), executionId);
    }

    @Override
    public boolean endAnonymousExecution(BuildSessionData buildSessionData, String optionalLabId, String testGroupId) {
        String labId = LabIdResolver.resolve(buildSessionData, optionalLabId);
        return this.sendEndExecutionRequest(Routes.buildEndExecutionUrl(this.getServer(), labId, null, AgentId.getAgentId(), testGroupId), null);
    }

    @Override
    public boolean endColoredExecution(String executionId, BuildSessionData buildSessionData, String optionalLabId, String testGroupId) {
        String labId = LabIdResolver.resolve(buildSessionData, optionalLabId);
        return this.sendEndExecutionRequest(Routes.buildEndExecutionUrl(this.getServer(), labId, executionId, AgentId.getAgentId(), testGroupId), executionId);
    }

    @Override
    public ExecutionData getActiveExecution(String labId) {
        try {
            String url = Routes.buildGetExecutionUrl(this.getServer(), labId);
            return this.sendGetExecutionRequest(url, labId);
        }
        catch (Exception e) {
            LOG.error("Failed to get active execution for labId:'{}'", (Object)labId, (Object)e);
            return null;
        }
    }

    @Override
    public ExecutionData getExecution(String labId, String executionId) {
        try {
            String url = Routes.buildGetExecutionUrl(this.getServer(), labId, executionId);
            return this.sendGetExecutionRequest(url, labId);
        }
        catch (Exception e) {
            LOG.error("Failed to get execution for executionId:{}, labId:{}'", executionId, labId, e);
            return null;
        }
    }

    @Override
    public ExecutionResolution getExecutionWithFullStatus(String labId, String executionId) {
        try {
            String url = Routes.buildGetExecutionUrlWithFullStatus(this.getServer(), labId, executionId);
            return ExecutionResolution.ofSuccess(this.sendGetExecutionRequest(url, labId));
        }
        catch (Exception e) {
            LOG.error("Failed to get execution with full status for executionId:{}, labId:{}'", executionId, labId, e);
            return ExecutionResolution.ofFailure();
        }
    }

    protected ExecutionData sendGetExecutionRequest(String url, String labId) {
        SLHttpResult<ExecutionStateProxy.GetExecutionResponse> response = this.getHttpClient().sendGetRetry(new SLHttpRequest<ExecutionStateProxy.GetExecutionResponse>(this.getTag(), url, ExecutionStateProxy.GetExecutionResponse.class, true));
        ExecutionStateProxy.GetExecutionResponse getExecutionResponse = response.getResponseObject();
        ExecutionData executionData = getExecutionResponse.getExecutionData();
        if (executionData != null && executionData.getExecutionId() == null) {
            executionData = null;
        }
        if (executionData != null) {
            LOG.info("Found execution {} for labId:'{}'", (Object)executionData, (Object)labId);
        } else {
            LOG.info("Execution was not found for labId '{}'", (Object)labId);
        }
        return executionData;
    }

    protected boolean sendStartExecutionRequest(String url, StartExecutionRequest request, String executionId) {
        try {
            SLHttpResult<String> slHttpResult = this.getHttpClient().sendPostRetry(new SLHttpRequest<String>(this.getTag(), url, request, String.class));
            int statusCode = slHttpResult.getStatusCode();
            if (statusCode == 201) {
                this.notifyExecutionIdCreated(executionId);
                return true;
            }
            this.notifyExecutionCreateError(executionId, "agent received response status " + statusCode);
            return false;
        }
        catch (Exception e) {
            this.notifyExecutionCreateError(executionId, "exception - " + ExceptionStackTrace.toString(e));
            return false;
        }
    }

    protected boolean sendEndExecutionRequest(String url, String executionId) {
        try {
            SLHttpResult<String> httpResponse = this.getHttpClient().sendDeleteRetry(new SLHttpRequest<String>(this.getTag(), url, String.class));
            int statusCode = httpResponse.getStatusCode();
            if (statusCode == 202) {
                this.notifyExecutionIdDeleted(executionId);
                return true;
            }
            this.notifyExecutionDeleteError(executionId, "agent received response status " + statusCode);
            return false;
        }
        catch (Exception e) {
            this.notifyExecutionDeleteError(executionId, "exception - " + ExceptionStackTrace.toString(e));
            return false;
        }
    }

    protected void notifyExecutionIdCreated(String executionId) {
        LOG.info("Execution {} was created", (Object)this.executionIdString(executionId));
        if (this.eventsController != null) {
            this.eventsController.verifyTimeClock(false);
            this.eventsController.sendEvent(new ExecutionIdEvents.ExecutionIdCreatedEvent(this.executionIdString(executionId), this.eventsController.getTimeClockDispatcher().getTimeClock()));
        }
    }

    protected void notifyExecutionCreateError(String executionId, String reason) {
        this.notifyExecutionCreateDeleteError(FAILED_CREATE_EXECUTION_FMT, executionId, reason);
    }

    protected void notifyExecutionIdDeleted(String executionId) {
        LOG.info("The end execution request for {} was accepted successfully", (Object)this.executionIdString(executionId));
        if (this.eventsController != null) {
            this.eventsController.verifyTimeClock(false);
            this.eventsController.sendEvent(new ExecutionIdEvents.ExecutionIdDeletedEvent(this.executionIdString(executionId), this.eventsController.getTimeClockDispatcher().getTimeClock()));
        }
    }

    protected void notifyExecutionDeleteError(String executionId, String reason) {
        this.notifyExecutionCreateDeleteError(FAILED_DELETE_EXECUTION_FMT, executionId, reason);
    }

    private void notifyExecutionCreateDeleteError(String errorFormat, String executionId, String reason) {
        String error = String.format(errorFormat, this.executionIdString(executionId), reason);
        LOG.info(error);
        if (this.eventsController != null) {
            this.eventsController.sendSuperUserMessage(AgentEventsController.NotifMsgLevel.INFO, error);
        }
    }

    private String executionIdString(String executionId) {
        return executionId != null ? executionId : ANONYMOUS_EXECUTION;
    }

    @Override
    public String getTag() {
        return "TST";
    }

    static class Routes {
        Routes() {
        }

        static String buildStartExecutionUrl(String server) {
            return Routes.createRootUrlBuilder_v3(server).build();
        }

        private static String buildEndExecutionUrl(String server, String labId, String executionId, String agentId, String testGroupId) {
            UrlBuilder urlBuilder = Routes.buildUrlWithLabIdParam(server, labId).withQueryParam("agentId", agentId).withNonNullQueryParam("testGroupId", testGroupId);
            if (executionId == null) {
                return urlBuilder.build();
            }
            return urlBuilder.withQueryParam("executionId", executionId).build();
        }

        static String buildGetExecutionUrl(String server, String labId) {
            return Routes.createRootUrlBuilder_v4(server, labId).build();
        }

        static String buildGetExecutionUrl(String server, String labId, String executionId) {
            return Routes.createRootUrlBuilder_v4(server, labId).withQueryParam("executionId", executionId).build();
        }

        static String buildGetExecutionUrlWithFullStatus(String server, String labId, String executionId) {
            return Routes.createRootUrlBuilder_v4(server, labId).withQueryParam("includeFullStatus", "true").withQueryParam("executionId", executionId).build();
        }

        private static UrlBuilder createRootUrlBuilder_v3(String server) {
            return new UrlBuilder().withHost(server).withPath(URL_PATHS_V3).withQueryParam("agentId", AgentId.getAgentId());
        }

        private static UrlBuilder createRootUrlBuilder_v4(String server, String labId) {
            return new UrlBuilder().withHost(server).withPath("v4", "testExecution", labId).withQueryParam("agentId", AgentId.getAgentId());
        }

        private static UrlBuilder buildUrlWithLabIdParam(String server, String labId) {
            return Routes.createRootUrlBuilder_v3(server).withQueryParam("labId", labId);
        }
    }
}

