/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.logging;

import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.DefaultLogManager;
import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.infra.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFactory {
    private static LogManager logManager = new DefaultLogManager();
    private static Level consoleLogLevel;

    public static void bindLogManager(LogManager logManager) {
        LogFactory.logManager = logManager;
    }

    public static void setConsoleLogLevel(Level level) {
        consoleLogLevel = level;
    }

    public static Logger getLogger(String name) {
        Logger logger = logManager.getFrameworkLogger(name);
        if (logger == null) {
            logger = LoggerFactory.getLogger(name);
        }
        return logger;
    }

    public static Logger getLogger(Class<?> clazz) {
        Logger logger = logManager.getFrameworkLogger(clazz);
        if (logger == null) {
            logger = LoggerFactory.getLogger(clazz.getSimpleName());
        }
        return logger;
    }

    public static ConsoleLogger createConsoleLogger() {
        return new ConsoleLogger(LogFactory.getConsoleLogLevel());
    }

    public static ConsoleLogger createConsoleLogger(String context) {
        return new ConsoleLogger(ConsoleLogger.getComponentTag() + ":" + context, LogFactory.getConsoleLogLevel());
    }

    private static Level getConsoleLogLevel() {
        return consoleLogLevel == null ? Level.INFO : consoleLogLevel;
    }

    public static LogManager getLogManager() {
        return logManager;
    }

    public static boolean isLogEnabled(Level level) {
        return level.enabledAt(LogFactory.getConfiguredLogLevel());
    }

    public static Level getConfiguredLogLevel() {
        return logManager.getConfiguredLogLevel();
    }

    private LogFactory() {
        logManager = new DefaultLogManager();
    }
}

