/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.logging;

import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.logging.LogLevelToStringFormatter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class JsonLogger<T> {
    private static Logger LOG = LogFactory.getLogger(JsonLogger.class);
    private String origin;
    private Level level;
    private String textBefore;
    private List<T> values;
    private int listMaxSize;
    private static int MAX_LIST_SIZE = 100;

    public static <T> void logAsJson(String origin, Level level, String textBefore, List<T> values2) {
        JsonLogger.logAsJson(origin, level, textBefore, values2, MAX_LIST_SIZE);
    }

    public static <T> void logAsJson(String origin, Level level, String textBefore, List<T> values2, int maxSize) {
        new JsonLogger<T>(origin, level, textBefore, values2, maxSize).logAll();
    }

    protected JsonLogger(String origin, Level level, String textBefore, List<T> values2, int listMaxSize) {
        this.origin = origin;
        this.level = level;
        this.textBefore = textBefore;
        this.values = values2;
        this.listMaxSize = listMaxSize;
    }

    protected void logAll() {
        if (!this.isLogEnable()) {
            return;
        }
        int ctr = 0;
        while (ctr < this.values.size()) {
            int fromIndex = ctr;
            int toIndex = Math.min(fromIndex + this.listMaxSize, this.values.size());
            this.logListAsJson(fromIndex, toIndex);
            ctr = toIndex;
        }
    }

    protected void logListAsJson(int fromIndex, int toIndex) {
        String FORMAT_STR = this.origin + " : {} (entries {}-{} of {}):{}";
        ArrayList<T> partialList = new ArrayList<T>();
        for (int i = fromIndex; i < toIndex; ++i) {
            partialList.add(this.values.get(i));
        }
        Object[] logArgs = new Object[]{this.textBefore, fromIndex + 1, toIndex, this.values.size(), LogLevelToStringFormatter.toStringAsJson(this.level, partialList, fromIndex + 1)};
        this.logMessage(FORMAT_STR, logArgs);
    }

    protected void logMessage(String format, Object[] logArgs) {
        if (this.level == Level.ERROR) {
            LOG.error(format, logArgs);
        }
        if (this.level == Level.INFO) {
            LOG.info(format, logArgs);
        }
        if (this.level == Level.DEBUG) {
            LOG.debug(format, logArgs);
        }
        if (this.level == Level.WARN) {
            LOG.warn(format, logArgs);
        }
        if (this.level == Level.TRACE) {
            LOG.trace(format, logArgs);
        }
    }

    protected boolean isLogEnable() {
        return LogFactory.isLogEnabled(this.level);
    }
}

